/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PsiClassType
extends PsiType {
    public static final PsiClassType[] EMPTY_ARRAY = new PsiClassType[0];
    protected LanguageLevel myLanguageLevel;

    @Nullable
    public abstract PsiClass resolve();

    public abstract String getClassName();

    @NotNull
    public abstract PsiType[] getParameters();

    public boolean equals(Object obj) {
        PsiClass otherClass;
        ClassResolveResult otherResult;
        String otherClassName;
        if (!(obj instanceof PsiClassType)) {
            return false;
        }
        PsiClassType otherClassType = (PsiClassType)obj;
        if (!this.isValid() || !otherClassType.isValid()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        String className = this.getClassName();
        if (!Comparing.equal(className, otherClassName = otherClassType.getClassName())) {
            return false;
        }
        ClassResolveResult result = this.resolveGenerics();
        if (result == (otherResult = otherClassType.resolveGenerics())) {
            return true;
        }
        PsiClass aClass = result.getElement();
        if (!PsiClassType.areClassesEqual(aClass, otherClass = otherResult.getElement())) {
            return false;
        }
        if (aClass == null) {
            return true;
        }
        return PsiUtil.equalOnEquivalentClasses(result.getSubstitutor(), aClass, otherResult.getSubstitutor(), otherClass);
    }

    private static boolean areClassesEqual(PsiClass aClass, PsiClass otherClass) {
        if (aClass == null || otherClass == null) {
            return aClass == otherClass;
        }
        return aClass.getManager().areElementsEquivalent(aClass, otherClass);
    }

    public boolean hasParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        if (resolveResult.getElement() == null) {
            return false;
        }
        Iterator<PsiTypeParameter> iterator = PsiUtil.typeParametersIterator(resolveResult.getElement());
        if (!iterator.hasNext()) {
            return false;
        }
        while (iterator.hasNext()) {
            PsiTypeParameter parameter = iterator.next();
            if (resolveResult.getSubstitutor().substitute(parameter) != null) continue;
            return false;
        }
        return true;
    }

    public boolean hasNonTrivialParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        if (resolveResult.getElement() == null) {
            return false;
        }
        Iterator<PsiTypeParameter> iterator = PsiUtil.typeParametersIterator(resolveResult.getElement());
        if (!iterator.hasNext()) {
            return false;
        }
        while (iterator.hasNext()) {
            PsiTypeParameter parameter = iterator.next();
            PsiType type = resolveResult.getSubstitutor().substitute(parameter);
            if (type == null || type instanceof PsiWildcardType && ((PsiWildcardType)type).getBound() == null) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        String className = this.getClassName();
        if (className == null) {
            return 0;
        }
        return className.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray;
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            psiTypeArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiClassType.getSuperTypes must not return null");
            return psiTypeArray;
        }
        PsiClassType[] superTypes = aClass.getSuperTypes();
        PsiType[] subtitutionResults = new PsiType[superTypes.length];
        for (int i = 0; i < superTypes.length; ++i) {
            subtitutionResults[i] = resolveResult.getSubstitutor().substitute(superTypes[i]);
        }
        psiTypeArray = subtitutionResults;
        if (subtitutionResults != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiClassType.getSuperTypes must not return null");
    }

    public static boolean isRaw(ClassResolveResult resolveResult) {
        if (resolveResult.getElement() == null) {
            return false;
        }
        return PsiUtil.isRawSubstitutor(resolveResult.getElement(), resolveResult.getSubstitutor());
    }

    public boolean isRaw() {
        return PsiClassType.isRaw(this.resolveGenerics());
    }

    @NotNull
    public abstract ClassResolveResult resolveGenerics();

    @NotNull
    public abstract PsiClassType rawType();

    @Override
    @NotNull
    public abstract GlobalSearchScope getResolveScope();

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitClassType(this);
    }

    @NotNull
    public abstract LanguageLevel getLanguageLevel();

    public abstract PsiClassType setLanguageLevel(LanguageLevel var1);

    public static interface ClassResolveResult
    extends JavaResolveResult {
        public static final ClassResolveResult EMPTY = new ClassResolveResult(){

            public PsiClass getElement() {
                return null;
            }

            public PsiSubstitutor getSubstitutor() {
                return PsiSubstitutor.EMPTY;
            }

            public boolean isValidResult() {
                return false;
            }

            public boolean isAccessible() {
                return false;
            }

            public boolean isStaticsScopeCorrect() {
                return false;
            }

            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }
        };

        public PsiClass getElement();
    }
}

