/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtil {
    private GenericsUtil() {
    }

    public static PsiType getGreatestLowerBound(PsiType type1, PsiType type2) {
        return PsiIntersectionType.createIntersection(type1, type2);
    }

    @Nullable
    public static PsiType getLeastUpperBound(PsiType type1, PsiType type2, PsiManager manager) {
        if (TypeConversionUtil.isPrimitiveAndNotNull(type1) || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        if (TypeConversionUtil.isNullType(type1)) {
            return type2;
        }
        if (TypeConversionUtil.isNullType(type2)) {
            return type1;
        }
        return GenericsUtil.getLeastUpperBound(type1, type2, new LinkedHashSet<Pair<PsiType, PsiType>>(), manager);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private static PsiType getLeastUpperBound(PsiType type1, PsiType type2, Set<Pair<PsiType, PsiType>> compared, PsiManager manager) {
        block11: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    break block5;
lbl1:
                                                    // 11 sources

                                                    throw new IllegalStateException("@NotNull method com/intellij/psi/GenericsUtil.getLeastUpperBound must not return null");
                                                }
                                                if (!(type1 instanceof PsiCapturedWildcardType)) break block6;
                                                v0 = GenericsUtil.getLeastUpperBound(((PsiCapturedWildcardType)type1).getUpperBound(), type2, compared, manager);
                                                if (v0 == null) ** GOTO lbl1
                                                return v0;
                                            }
                                            if (!(type2 instanceof PsiCapturedWildcardType)) break block7;
                                            v0 = GenericsUtil.getLeastUpperBound(type1, ((PsiCapturedWildcardType)type2).getUpperBound(), compared, manager);
                                            if (v0 == null) ** GOTO lbl1
                                            return v0;
                                        }
                                        if (!(type1 instanceof PsiWildcardType)) break block8;
                                        v0 = GenericsUtil.getLeastUpperBound(((PsiWildcardType)type1).getExtendsBound(), type2, compared, manager);
                                        if (v0 == null) ** GOTO lbl1
                                        return v0;
                                    }
                                    if (!(type2 instanceof PsiWildcardType)) break block9;
                                    v0 = GenericsUtil.getLeastUpperBound(type1, ((PsiWildcardType)type2).getExtendsBound(), compared, manager);
                                    if (v0 == null) ** GOTO lbl1
                                    return v0;
                                }
                                if (!(type1 instanceof PsiArrayType) || !(type2 instanceof PsiArrayType)) break block10;
                                componentType = GenericsUtil.getLeastUpperBound(((PsiArrayType)type1).getComponentType(), ((PsiArrayType)type2).getComponentType(), manager);
                                if (componentType == null) break block11;
                                v0 = componentType.createArrayType();
                                if (v0 == null) ** GOTO lbl1
                                return v0;
                            }
                            if (!(type1 instanceof PsiIntersectionType)) break block12;
                            newConjuncts = new LinkedHashSet<PsiType>();
                            for (PsiType type : conjuncts = ((PsiIntersectionType)type1).getConjuncts()) {
                                newConjuncts.add(GenericsUtil.getLeastUpperBound(type, type2, compared, manager));
                            }
                            v0 = PsiIntersectionType.createIntersection(newConjuncts.toArray(new PsiType[newConjuncts.size()]));
                            if (v0 == null) ** GOTO lbl1
                            return v0;
                        }
                        if (!(type2 instanceof PsiIntersectionType)) break block13;
                        v0 = GenericsUtil.getLeastUpperBound(type2, type1, compared, manager);
                        if (v0 == null) ** GOTO lbl1
                        return v0;
                    }
                    if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) break block11;
                    classResolveResult1 = ((PsiClassType)type1).resolveGenerics();
                    classResolveResult2 = ((PsiClassType)type2).resolveGenerics();
                    aClass = classResolveResult1.getElement();
                    bClass = classResolveResult2.getElement();
                    if (aClass != null && bClass != null) break block14;
                    v0 = manager.getElementFactory().createTypeByFQClassName("java.lang.Object", GlobalSearchScope.allScope(manager.getProject()));
                    if (v0 == null) ** GOTO lbl1
                    return v0;
                }
                supers = GenericsUtil.getLeastUpperClasses(aClass, bClass);
                if (supers.length != 0) break block15;
                v0 = manager.getElementFactory().createTypeByFQClassName("java.lang.Object", aClass.getResolveScope());
                if (v0 == null) ** GOTO lbl1
                return v0;
            }
            conjuncts = new PsiClassType[supers.length];
            for (i = 0; i < supers.length; ++i) {
                aSuper = supers[i];
                subst1 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, aClass, classResolveResult1.getSubstitutor());
                subst2 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, bClass, classResolveResult2.getSubstitutor());
                iterator = PsiUtil.typeParametersIterator(aSuper);
                substitutor = PsiSubstitutor.EMPTY;
                while (iterator.hasNext()) {
                    parameter = iterator.next();
                    mapping1 = subst1.substitute(parameter);
                    mapping2 = subst2.substitute(parameter);
                    if (mapping1 != null && mapping2 != null) {
                        substitutor = substitutor.put(parameter, GenericsUtil.getLeastContainingTypeArgument(mapping1, mapping2, compared, manager));
                        continue;
                    }
                    substitutor = substitutor.put(parameter, null);
                }
                conjuncts[i] = manager.getElementFactory().createType(aSuper, substitutor);
            }
            v0 = PsiIntersectionType.createIntersection(conjuncts);
            if (v0 == null) ** GOTO lbl1
            return v0;
        }
        if ((v0 = manager.getElementFactory().createTypeByFQClassName("java.lang.Object", GlobalSearchScope.allScope(manager.getProject()))) != null) ** break;
        ** while (true)
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiType getLeastContainingTypeArgument(PsiType type1, PsiType type2, Set<Pair<PsiType, PsiType>> compared, PsiManager manager) {
        Pair<PsiType, PsiType> types = new Pair<PsiType, PsiType>(type1, type2);
        if (compared.contains(types)) {
            return PsiWildcardType.createUnbounded(manager);
        }
        compared.add(types);
        try {
            if (type1 instanceof PsiWildcardType) {
                PsiWildcardType wild1 = (PsiWildcardType)type1;
                PsiType bound1 = wild1.getBound();
                if (bound1 == null) {
                    PsiType psiType = type1;
                    return psiType;
                }
                if (type2 instanceof PsiWildcardType) {
                    PsiWildcardType wild2 = (PsiWildcardType)type2;
                    PsiType bound2 = wild2.getBound();
                    if (bound2 == null) {
                        PsiWildcardType psiWildcardType = wild1;
                        return psiWildcardType;
                    }
                    if (wild1.isExtends() == wild2.isExtends()) {
                        PsiWildcardType psiWildcardType = wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, bound2, compared, manager)) : PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, bound2));
                        return psiWildcardType;
                    }
                    PsiType psiType = bound1.equals(bound2) ? bound1 : PsiWildcardType.createUnbounded(manager);
                    return psiType;
                }
                PsiWildcardType psiWildcardType = wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, type2, compared, manager)) : (wild1.isSuper() ? PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, type2)) : wild1);
                return psiWildcardType;
            }
            if (type2 instanceof PsiWildcardType) {
                PsiType psiType = GenericsUtil.getLeastContainingTypeArgument(type2, type1, compared, manager);
                return psiType;
            }
            if (type1.equals(type2)) {
                PsiType psiType = type1;
                return psiType;
            }
            PsiWildcardType psiWildcardType = PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(type1, type2, compared, manager));
            return psiWildcardType;
        }
        finally {
            compared.remove(types);
        }
    }

    public static PsiClass[] getLeastUpperClasses(PsiClass aClass, PsiClass bClass) {
        if (InheritanceUtil.isInheritorOrSelf(aClass, bClass, true)) {
            return new PsiClass[]{bClass};
        }
        LinkedHashSet<PsiClass> supers = new LinkedHashSet<PsiClass>();
        GenericsUtil.getLeastUpperClassesInner(aClass, bClass, supers);
        return supers.toArray(new PsiClass[supers.size()]);
    }

    private static void getLeastUpperClassesInner(PsiClass aClass, PsiClass bClass, Set<PsiClass> supers) {
        if (bClass.isInheritor(aClass, true)) {
            GenericsUtil.addSuper(supers, aClass);
        } else {
            PsiClass[] aSupers;
            for (PsiClass aSuper : aSupers = aClass.getSupers()) {
                GenericsUtil.getLeastUpperClassesInner(aSuper, bClass, supers);
            }
        }
    }

    private static void addSuper(Set<PsiClass> supers, PsiClass classToAdd) {
        Iterator<PsiClass> iterator = supers.iterator();
        while (iterator.hasNext()) {
            PsiClass superClass = iterator.next();
            if (InheritanceUtil.isInheritorOrSelf(superClass, classToAdd, true)) {
                return;
            }
            if (!classToAdd.isInheritor(superClass, true)) continue;
            iterator.remove();
        }
        supers.add(classToAdd);
    }

    public static boolean isTypeArgumentsApplicable(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor, PsiElement context) {
        for (PsiTypeParameter typeParameter : typeParams) {
            PsiClassType[] extendsTypes;
            PsiType substituted = substitutor.substitute(typeParameter);
            if (substituted == null) {
                return true;
            }
            substituted = PsiUtil.captureToplevelWildcards(substituted, context);
            for (PsiClassType type : extendsTypes = typeParameter.getExtendsListTypes()) {
                PsiType extendsType = substitutor.substitute(type);
                if (extendsType.isAssignableFrom(substituted)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isFromExternalTypeLanguage(PsiType type) {
        return type.getInternalCanonicalText().equals(type.getCanonicalText());
    }

    public static PsiType getVariableTypeByExpressionType(PsiType type) {
        PsiType componentType = (type = type.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType type = componentType.accept(this);
                if (type == componentType) {
                    return arrayType;
                }
                return type.createArrayType();
            }

            @Override
            public PsiType visitType(PsiType type) {
                return type;
            }

            @Override
            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                PsiManager manager = wildcardType.getManager();
                if (bound != null) {
                    PsiType acceptedBound = bound.accept(this);
                    if (acceptedBound instanceof PsiWildcardType) {
                        if (((PsiWildcardType)acceptedBound).isExtends() != wildcardType.isExtends()) {
                            return PsiWildcardType.createUnbounded(manager);
                        }
                        return acceptedBound;
                    }
                    if (acceptedBound.equals(bound)) {
                        return wildcardType;
                    }
                    return wildcardType.isExtends() ? PsiWildcardType.createExtends(manager, acceptedBound) : PsiWildcardType.createSuper(manager, acceptedBound);
                }
                return wildcardType;
            }

            @Override
            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return capturedWildcardType.getWildcard().accept(this);
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass aClass = resolveResult.getElement();
                if (aClass == null) {
                    return classType;
                }
                boolean toExtend = false;
                Iterator<PsiTypeParameter> iterator = PsiUtil.typeParametersIterator(aClass);
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                while (iterator.hasNext()) {
                    PsiType toPut;
                    PsiTypeParameter typeParameter = iterator.next();
                    PsiType typeArgument = resolveResult.getSubstitutor().substitute(typeParameter);
                    if (typeArgument instanceof PsiCapturedWildcardType) {
                        toExtend = true;
                    }
                    if (typeArgument instanceof PsiWildcardType && ((PsiWildcardType)typeArgument).getBound() instanceof PsiIntersectionType) {
                        toExtend = true;
                    }
                    if (typeArgument == null) {
                        toPut = null;
                    } else {
                        PsiType accepted = typeArgument.accept(this);
                        toPut = typeArgument instanceof PsiIntersectionType ? PsiWildcardType.createExtends(typeParameter.getManager(), accepted) : accepted;
                    }
                    substitutor = substitutor.put(typeParameter, toPut);
                }
                PsiManager manager = aClass.getManager();
                PsiType result = manager.getElementFactory().createType(aClass, substitutor);
                if (toExtend) {
                    result = PsiWildcardType.createExtends(manager, result);
                }
                return result;
            }
        })).getDeepComponentType();
        if (componentType instanceof PsiWildcardType) {
            componentType = ((PsiWildcardType)componentType).getExtendsBound();
            int dims = type.getArrayDimensions();
            for (int i = 0; i < dims; ++i) {
                componentType = componentType.createArrayType();
            }
            return componentType;
        }
        return type;
    }
}

