/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class ProfileEx
implements Profile {
    public String myName;
    public File myFile;
    private static final Logger LOG = Logger.getInstance("com.intellij.profile.ProfileEx");
    public boolean myLocal = true;
    protected ProfileManager myProfileMananger;

    public ProfileEx(String name) {
        this.myName = name;
    }

    public ProfileEx(String name, File file) {
        this.myName = name;
        this.myFile = file;
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public File getFile() {
        return this.myFile;
    }

    public void copyFrom(Profile profile) {
        try {
            Element config = new Element("config");
            profile.writeExternal(config);
            this.readExternal(config);
        }
        catch (WriteExternalException e) {
            LOG.error(e);
        }
        catch (InvalidDataException e) {
            LOG.error(e);
        }
    }

    public void setLocal(boolean isLocal) {
        this.myLocal = isLocal;
    }

    public boolean isLocal() {
        return this.myLocal;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.myProfileMananger = profileManager;
    }

    public ProfileManager getProfileManager() {
        return this.myProfileMananger;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileEx)) {
            return false;
        }
        ProfileEx profileEx = (ProfileEx)o;
        return this.myName.equals(profileEx.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public int compareTo(Object o) {
        if (o instanceof Profile) {
            return this.getName().compareToIgnoreCase(((Profile)o).getName());
        }
        return 0;
    }
}

