/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProjectProfileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectProfileManager
extends ProjectProfileManager {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.profile.DefaultProjectProfileManager");
    @NonNls
    private static final String PROFILES = "profiles";
    @NonNls
    private static final String SCOPES = "scopes";
    @NonNls
    private static final String SCOPE = "scope";
    @NonNls
    private static final String PROFILE = "profile";
    @NonNls
    private static final String NAME = "name";
    protected Project myProject;
    private LinkedHashMap<NamedScope, String> myScopeToProfileMap = new LinkedHashMap();
    private String myProfileType;
    public String PROJECT_PROFILE;
    protected ApplicationProfileManager myApplicationProfileManager;
    public boolean USE_PROJECT_LEVEL_SETTINGS = false;
    protected Map<String, Profile> myProfiles = new HashMap<String, Profile>();

    public DefaultProjectProfileManager(Project project, String profileType) {
        this.myProject = project;
        this.myProfileType = profileType;
        this.myApplicationProfileManager = ApplicationProfileManager.getProfileManager(profileType);
        LOG.assertTrue(this.myApplicationProfileManager != null);
    }

    @Override
    public String assignProfileToScope(String profile, @NotNull NamedScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/profile/DefaultProjectProfileManager.assignProfileToScope must not be null");
        }
        this.myScopeToProfileMap.put(scope, profile);
        return profile;
    }

    @Override
    public void deassignProfileFromScope(NamedScope scope) {
        String profile = (String)this.myScopeToProfileMap.remove(scope);
        if (!this.myScopeToProfileMap.containsValue(profile)) {
            this.myProfiles.remove(profile);
        }
    }

    @Override
    public String getProfileName(PsiFile psiFile) {
        if (this.USE_PROJECT_LEVEL_SETTINGS) {
            DependencyValidationManager scopeManager = DependencyValidationManager.getInstance(this.myProject);
            for (NamedScope scope : this.myScopeToProfileMap.keySet()) {
                PackageSet packageSet = scope.getValue();
                if (packageSet == null || !packageSet.contains(psiFile, scopeManager)) continue;
                return this.myScopeToProfileMap.get(scope);
            }
            Profile profile = this.myProfiles.get(this.PROJECT_PROFILE);
            if (profile != null) {
                return profile.getName();
            }
        }
        return this.myApplicationProfileManager.getRootProfile().getName();
    }

    @Override
    public Profile getProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/profile/DefaultProjectProfileManager.getProfile must not be null");
        }
        return this.USE_PROJECT_LEVEL_SETTINGS ? this.myProfiles.get(name) : this.myApplicationProfileManager.getProfile(name);
    }

    @Override
    public void updateProfile(Profile profile) {
        if (profile.isLocal()) {
            this.myApplicationProfileManager.updateProfile(profile);
        } else {
            this.myProfiles.put(profile.getName(), profile);
        }
    }

    @Override
    public LinkedHashMap<NamedScope, String> getProfilesUsedInProject() {
        return this.myScopeToProfileMap;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        List children;
        Element scopes;
        DefaultJDOMExternalizer.readExternal(this, element);
        Element profiles = element.getChild(PROFILES);
        if (profiles != null) {
            for (Object p : profiles.getChildren(PROFILE)) {
                Element profileElement = (Element)p;
                Profile profile = this.myApplicationProfileManager.createProfile();
                profile.setProfileManager(this);
                profile.readExternal(profileElement);
                String name = profile.getName();
                if (this.myApplicationProfileManager.getProfile(name) != null) {
                    this.myApplicationProfileManager.deleteProfile(name);
                }
                this.myProfiles.put(name, profile);
            }
        }
        if ((scopes = element.getChild(SCOPES)) != null && (children = scopes.getChildren(SCOPE)) != null) {
            DependencyValidationManager holder = DependencyValidationManager.getInstance(this.myProject);
            for (Object s : children) {
                NamedScope scope;
                Element scopeElement = (Element)s;
                String profile = scopeElement.getAttributeValue(PROFILE);
                if (profile == null || !this.myProfiles.containsKey(profile) || (scope = holder.getScope(scopeElement.getAttributeValue(NAME))) == null) continue;
                this.myScopeToProfileMap.put(scope, profile);
            }
        }
        if (this.USE_PROJECT_LEVEL_SETTINGS && this.PROJECT_PROFILE == null) {
            this.getProjectProfileImpl();
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element);
        LinkedHashMap<NamedScope, String> usedProfiles = this.getProfilesUsedInProject();
        HashSet profilesSet = new HashSet(usedProfiles.values());
        profilesSet.add(this.PROJECT_PROFILE);
        ArrayList<String> sortedProfiles = new ArrayList<String>(this.myProfiles.keySet());
        Collections.sort(sortedProfiles);
        if (!sortedProfiles.isEmpty()) {
            Element assignedScopes = new Element(SCOPES);
            ArrayList scopes = new ArrayList(usedProfiles.keySet());
            Collections.sort(scopes, new Comparator<NamedScope>(){

                @Override
                public int compare(NamedScope o1, NamedScope o2) {
                    LOG.assertTrue(o1 != null);
                    LOG.assertTrue(o2 != null);
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (NamedScope scope : scopes) {
                Element scopeElement = new Element(SCOPE);
                scopeElement.setAttribute(PROFILE, (String)usedProfiles.get(scope));
                scopeElement.setAttribute(NAME, scope.getName());
                assignedScopes.addContent(scopeElement);
            }
            element.addContent(assignedScopes);
            Element profiles = new Element(PROFILES);
            for (String profile : sortedProfiles) {
                Profile projectProfile = this.myProfiles.get(profile);
                if (projectProfile == null) continue;
                Element profileElement = new Element(PROFILE);
                projectProfile.writeExternal(profileElement);
                profiles.addContent(profileElement);
            }
            element.addContent(profiles);
        }
    }

    @Override
    public String getProfileType() {
        return this.myProfileType;
    }

    @Override
    public Map<String, Profile> getProfiles() {
        this.getProjectProfileImpl();
        return this.myProfiles;
    }

    @Override
    public void clearProfileScopeAssignments() {
        this.myScopeToProfileMap.clear();
    }

    @Override
    public boolean useProjectLevelProfileSettings() {
        return this.USE_PROJECT_LEVEL_SETTINGS;
    }

    @Override
    public void useProjectLevelProfileSettings(boolean useProjectLevelSettings) {
        this.USE_PROJECT_LEVEL_SETTINGS = useProjectLevelSettings;
    }

    public void updateAdditionalSettings() {
    }

    @Override
    public String[] getAvailableProfileNames() {
        return this.USE_PROJECT_LEVEL_SETTINGS ? this.myProfiles.keySet().toArray(new String[this.myProfiles.keySet().size()]) : this.myApplicationProfileManager.getAvailableProfileNames();
    }

    @Override
    public void deleteProfile(String name) {
        this.myProfiles.remove(name);
        if (this.USE_PROJECT_LEVEL_SETTINGS) {
            Iterator<NamedScope> iterator = this.myScopeToProfileMap.keySet().iterator();
            while (iterator.hasNext()) {
                NamedScope scope = iterator.next();
                if (!Comparing.strEqual(this.myScopeToProfileMap.get(scope), name)) continue;
                iterator.remove();
            }
        } else {
            this.myApplicationProfileManager.deleteProfile(name);
        }
    }

    @Override
    public File createUniqueProfileFile(String profileName) throws IOException {
        return null;
    }

    @Override
    public String getProjectProfile() {
        return this.PROJECT_PROFILE;
    }

    @Override
    public void setProjectProfile(String projectProfile) {
        this.PROJECT_PROFILE = projectProfile;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Profile getProjectProfileImpl() {
        if (this.PROJECT_PROFILE == null || this.myProfiles.isEmpty()) {
            String projectProfileName = "Project Default";
            this.setProjectProfile("Project Default");
            Profile projectProfile = this.myApplicationProfileManager.createProfile();
            projectProfile.copyFrom(this.myApplicationProfileManager.getRootProfile());
            projectProfile.setLocal(false);
            projectProfile.setName("Project Default");
            this.myProfiles.put("Project Default", projectProfile);
        } else if (!this.myProfiles.containsKey(this.PROJECT_PROFILE)) {
            String projectProfileAttempt = this.myProfiles.keySet().iterator().next();
            this.setProjectProfile(projectProfileAttempt);
        }
        Profile profile = this.myProfiles.get(this.PROJECT_PROFILE);
        profile.setProfileManager(this);
        Profile profile2 = profile;
        if (profile2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/profile/DefaultProjectProfileManager.getProjectProfileImpl must not return null");
        }
        return profile2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProfileStateSplitter
    implements StateSplitter {
        @Override
        public List<Pair<Element, String>> splitState(Element e) {
            Element[] elements;
            UniqueNameGenerator generator = new UniqueNameGenerator();
            ArrayList<Pair<Element, String>> result = new ArrayList<Pair<Element, String>>();
            for (Element element : elements = JDOMUtil.getElements(e)) {
                Element[] profiles;
                if (!element.getName().equals(DefaultProjectProfileManager.PROFILES)) continue;
                element.detach();
                for (Element profile : profiles = JDOMUtil.getElements(element)) {
                    Element[] options;
                    String profileName = null;
                    for (Element option : options = JDOMUtil.getElements(profile)) {
                        if (!option.getName().equals("option") || !option.getAttributeValue(DefaultProjectProfileManager.NAME).equals("myName")) continue;
                        profileName = option.getAttributeValue("value");
                    }
                    assert (profileName != null);
                    String name = generator.generateUniqueName(FileUtil.sanitizeFileName(profileName)) + ".xml";
                    result.add(new Pair<Element, String>(profile, name));
                }
            }
            result.add(new Pair<Element, String>(e, generator.generateUniqueName("profiles_settings") + ".xml"));
            return result;
        }

        @Override
        public void mergeStatesInto(Element target, Element[] elements) {
            Element profiles = new Element(DefaultProjectProfileManager.PROFILES);
            target.addContent(profiles);
            for (Element element : elements) {
                Element[] states;
                if (element.getName().equals(DefaultProjectProfileManager.PROFILE)) {
                    element.detach();
                    profiles.addContent(element);
                    continue;
                }
                for (Element state : states = JDOMUtil.getElements(element)) {
                    state.detach();
                    target.addContent(state);
                }
            }
        }
    }
}

