/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationProfileManager
extends ApplicationProfileManager {
    private List<ProfileChangeAdapter> myProfileChangeAdapters = new ArrayList<ProfileChangeAdapter>();
    private Map<String, Profile> myProfiles = new HashMap<String, Profile>();
    public String myCurrentProfile;
    private String myProfileType;
    private Computable<Profile> mySampleProfile;
    protected static final Logger LOG = Logger.getInstance("#com.intellij.profile.DefaultProfileManager");
    private String myDirName;

    public DefaultApplicationProfileManager(String profileType, Computable<Profile> sampleProfile, @NonNls String dirName) {
        this.myProfileType = profileType;
        this.mySampleProfile = sampleProfile;
        this.myDirName = dirName;
    }

    @Override
    public Profile createProfile() {
        return this.mySampleProfile.compute();
    }

    @Override
    public String getProfileType() {
        return this.myProfileType;
    }

    @Override
    public void addProfileChangeListener(ProfileChangeAdapter listener) {
        this.myProfileChangeAdapters.add(listener);
    }

    @Override
    public void addProfileChangeListener(ProfileChangeAdapter listener, Disposable parentDisposable) {
        ContainerUtil.add(listener, this.myProfileChangeAdapters, parentDisposable);
    }

    @Override
    public void removeProfileChangeListener(ProfileChangeAdapter listener) {
        this.myProfileChangeAdapters.remove(listener);
    }

    @Override
    public void fireProfileChanged(Profile profile) {
        for (ProfileChangeAdapter adapter : this.myProfileChangeAdapters) {
            adapter.profileChanged(profile);
        }
    }

    @Override
    public void fireProfileChanged(Profile oldProfile, Profile profile, NamedScope scope) {
        for (ProfileChangeAdapter adapter : this.myProfileChangeAdapters) {
            adapter.profileActivated(scope, oldProfile, profile);
        }
    }

    @Override
    public Map<String, Profile> getProfiles() {
        return this.myProfiles;
    }

    @Override
    public void setRootProfile(String rootProfile) {
        if (this.myCurrentProfile != null && !Comparing.strEqual(rootProfile, this.myCurrentProfile)) {
            this.fireProfileChanged(this.getProfile(this.myCurrentProfile), this.getProfile(rootProfile), null);
        }
        this.myCurrentProfile = rootProfile;
    }

    @Override
    public Profile getProfile(String name) {
        if (this.getProfiles().containsKey(name)) {
            return this.getProfiles().get(name);
        }
        return this.getRootProfile();
    }

    @Override
    public Profile getRootProfile() {
        if (this.getProfiles().containsKey(this.myCurrentProfile)) {
            return this.getProfiles().get(this.myCurrentProfile);
        }
        if (this.getProfiles().isEmpty()) {
            return this.mySampleProfile.compute();
        }
        return this.getProfiles().values().iterator().next();
    }

    @Override
    public void deleteProfile(String profile) {
        File file;
        Profile locProfile = this.getProfiles().get(profile);
        if (locProfile != null && (file = locProfile.getFile()) != null) {
            file.delete();
        }
        this.getProfiles().remove(profile);
    }

    @Override
    public void addProfile(Profile profile) {
        if (!this.getProfiles().containsKey(profile.getName())) {
            this.getProfiles().put(profile.getName(), profile);
        }
    }

    @Override
    public File createUniqueProfileFile(String profile) throws IOException {
        File profileDirectory = this.getProfileDirectory();
        String ext = ".xml";
        return new File(profileDirectory, profile + ".xml");
    }

    @Override
    public void updateProfile(Profile profile) {
        this.getProfiles().put(profile.getName(), profile);
    }

    public File getProfileDirectory() {
        String directoryPath = PathManager.getConfigPath() + File.separator + this.myDirName;
        File directory = new File(directoryPath);
        if (!directory.exists() && !directory.mkdir()) {
            return null;
        }
        return directory;
    }

    @Override
    public String[] getAvailableProfileNames() {
        Set<String> names = this.getProfiles().keySet();
        return names.toArray(new String[names.size()]);
    }
}

