/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java.types;

import com.intellij.pom.PomScope;
import com.intellij.pom.java.PomClass;
import com.intellij.pom.java.PomJavaAspect;
import com.intellij.pom.java.PomMemberOwner;
import com.intellij.pom.java.PomReferenceTypeElement;
import com.intellij.pom.java.types.PomClassType;
import com.intellij.pom.java.types.PomType;
import com.intellij.pom.java.types.PomTypeVisitor;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomPrimitiveType
implements PomType {
    protected static final PomPrimitiveType VOID = new PomPrimitiveType("void");
    protected static final PomPrimitiveType BYTE = new PomPrimitiveType("byte");
    protected static final PomPrimitiveType CHAR = new PomPrimitiveType("char");
    protected static final PomPrimitiveType DOUBLE = new PomPrimitiveType("double");
    protected static final PomPrimitiveType FLOAT = new PomPrimitiveType("float");
    protected static final PomPrimitiveType LONG = new PomPrimitiveType("long");
    protected static final PomPrimitiveType INT = new PomPrimitiveType("int");
    protected static final PomPrimitiveType SHORT = new PomPrimitiveType("short");
    protected static final PomPrimitiveType BOOLEAN = new PomPrimitiveType("boolean");
    protected static final PomPrimitiveType NULL = new PomPrimitiveType("null");
    private final String myName;
    private static final Map<String, PomPrimitiveType> ourQNameToUnboxed = new HashMap<String, PomPrimitiveType>();
    private static final Map<PomPrimitiveType, String> ourUnboxedToQName = new HashMap<PomPrimitiveType, String>();

    private PomPrimitiveType(@NonNls String name) {
        this.myName = name;
    }

    @Override
    public String getPresentableText() {
        return this.myName;
    }

    @Override
    public String getCanonicalText() {
        return this.myName;
    }

    public boolean equalsToText(String text) {
        return this.myName.equals(text);
    }

    public <A> A accept(PomTypeVisitor<A> visitor) {
        return visitor.visitPrimitiveType(this);
    }

    public static PomPrimitiveType getUnboxedType(PomType type) {
        if (!(type instanceof PomClassType)) {
            return null;
        }
        PomReferenceTypeElement pomClass = ((PomClassType)type).getReferenceClass();
        if (!(pomClass instanceof PomClass)) {
            return null;
        }
        if (!PomJavaAspect.getInstance(pomClass.getModel()).getLanguageLevel().hasEnumKeywordAndAutoboxing()) {
            return null;
        }
        return ourQNameToUnboxed.get(((PomClass)pomClass).getQualifiedName());
    }

    public PomClassType getBoxedType(PomJavaAspect manager, PomScope resolveScope) {
        if (!manager.getLanguageLevel().hasEnumKeywordAndAutoboxing()) {
            return null;
        }
        String boxedQName = ourUnboxedToQName.get(this);
        if (boxedQName == null) {
            return null;
        }
        PomMemberOwner aClass = manager.findClass(boxedQName, resolveScope);
        if (!(aClass instanceof PomClass)) {
            return null;
        }
        return null;
    }

    @Override
    public boolean isAssignableFrom(PomType type) {
        return false;
    }

    @Override
    public boolean isConvertibleTo(PomType type) {
        return false;
    }

    static {
        ourQNameToUnboxed.put("java.lang.Boolean", BOOLEAN);
        ourUnboxedToQName.put(BOOLEAN, "java.lang.Boolean");
        ourQNameToUnboxed.put("java.lang.Byte", BYTE);
        ourUnboxedToQName.put(BYTE, "java.lang.Byte");
        ourQNameToUnboxed.put("java.lang.Character", CHAR);
        ourUnboxedToQName.put(CHAR, "java.lang.Character");
        ourQNameToUnboxed.put("java.lang.Short", SHORT);
        ourUnboxedToQName.put(SHORT, "java.lang.Short");
        ourQNameToUnboxed.put("java.lang.Integer", INT);
        ourUnboxedToQName.put(INT, "java.lang.Integer");
        ourQNameToUnboxed.put("java.lang.Long", LONG);
        ourUnboxedToQName.put(LONG, "java.lang.Long");
        ourQNameToUnboxed.put("java.lang.Float", FLOAT);
        ourUnboxedToQName.put(FLOAT, "java.lang.Float");
        ourQNameToUnboxed.put("java.lang.Double", DOUBLE);
        ourUnboxedToQName.put(DOUBLE, "java.lang.Double");
    }
}

