/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.impl;

import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public abstract class PomTransactionBase
implements PomTransaction {
    private PsiElement myScope;
    private PomModelAspect myAspect;
    private PomModelEvent myAccumulatedEvent;

    public PomTransactionBase(PsiElement scope, PomModelAspect aspect) {
        this.myScope = scope;
        this.myAspect = aspect;
        this.myAccumulatedEvent = new PomModelEvent(scope.getManager().getProject().getModel());
    }

    public PomModelEvent getAccumulatedEvent() {
        return this.myAccumulatedEvent;
    }

    public void run() throws IncorrectOperationException {
        PomModelEvent event = this.runInner();
        if (event == null) {
            this.myAccumulatedEvent.registerChangeSet(this.myAspect, null);
            return;
        }
        for (PomModelAspect aspect : event.getChangedAspects()) {
            this.myAccumulatedEvent.merge(event);
        }
    }

    @Nullable
    public abstract PomModelEvent runInner() throws IncorrectOperationException;

    public PsiElement getChangeScope() {
        return this.myScope;
    }

    public PomModelAspect getTransactionAspect() {
        return this.myAspect;
    }
}

