/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.event;

import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomModelEvent
extends EventObject {
    private Map<PomModelAspect, PomChangeSet> myChangeSets;

    public PomModelEvent(PomModel source) {
        super(source);
    }

    public Set<PomModelAspect> getChangedAspects() {
        if (this.myChangeSets != null) {
            return this.myChangeSets.keySet();
        }
        return Collections.emptySet();
    }

    public void registerChangeSet(PomModelAspect aspect, PomChangeSet set) {
        if (this.myChangeSets == null) {
            this.myChangeSets = new HashMap<PomModelAspect, PomChangeSet>();
        }
        if (set != null) {
            this.myChangeSets.put(aspect, set);
        } else {
            this.myChangeSets.remove(aspect);
        }
    }

    public PomChangeSet getChangeSet(PomModelAspect aspect) {
        if (this.myChangeSets == null) {
            return null;
        }
        return this.myChangeSets.get(aspect);
    }

    public void merge(PomModelEvent event) {
        if (event.myChangeSets == null) {
            return;
        }
        if (this.myChangeSets == null) {
            this.myChangeSets = new HashMap<PomModelAspect, PomChangeSet>(event.myChangeSets);
            return;
        }
        for (Map.Entry<PomModelAspect, PomChangeSet> entry : event.myChangeSets.entrySet()) {
            PomModelAspect aspect = entry.getKey();
            PomChangeSet pomChangeSet = this.myChangeSets.get(aspect);
            if (pomChangeSet != null) {
                pomChangeSet.merge(entry.getValue());
                continue;
            }
            this.myChangeSets.put(aspect, entry.getValue());
        }
    }

    @Override
    public PomModel getSource() {
        return (PomModel)super.getSource();
    }
}

