/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.javaee.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacetBase;
import com.intellij.persistence.facet.PersistenceFacetConfiguration;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.TableInfoProvider;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceCommonUtil {
    private static Key<CachedValue<List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>>>> MODULE_PERSISTENCE_FACETS = Key.create("MODULE_PERSISTENCE_FACETS");

    private PersistenceCommonUtil() {
    }

    public static List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>> getAllPersistenceFacets(Project project) {
        ArrayList<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>> result = new ArrayList<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>>();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            result.addAll(PersistenceCommonUtil.getAllPersistenceFacets(module));
        }
        return result;
    }

    public static List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>> getAllPersistenceFacets(Module module) {
        ArrayList<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>> result = new ArrayList<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>>();
        for (Facet facet : FacetManager.getInstance(module).getAllFacets()) {
            if (!(facet instanceof PersistenceFacetBase)) continue;
            result.add((PersistenceFacetBase)facet);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>> getAllPersistenceFacetsWithDependencies(final Module module) {
        CachedValue<List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>>> cachedValue = module.getUserData(MODULE_PERSISTENCE_FACETS);
        if (cachedValue == null) {
            cachedValue = PsiManager.getInstance(module.getProject()).getCachedValuesManager().createCachedValue(new CachedValueProvider<List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>>>(){

                @Override
                public CachedValueProvider.Result<List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>>> compute() {
                    THashSet facets = new THashSet();
                    for (Module depModule : JamCommonUtil.getAllDependentModules(module)) {
                        facets.addAll(PersistenceCommonUtil.getAllPersistenceFacets(depModule));
                    }
                    return new CachedValueProvider.Result<List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>>>(new ArrayList(facets), ProjectRootManager.getInstance(module.getProject()));
                }
            }, false);
            module.putUserData(MODULE_PERSISTENCE_FACETS, cachedValue);
        }
        List<PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage>> list = cachedValue.getValue();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/persistence/util/PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies must not return null");
        }
        return list;
    }

    public static PersistenceModelBrowser createSameUnitsModelBrowser(PsiElement sourceElement, PersistenceClassRoleEnum sourceType, PersistenceClassRoleEnum type) {
        PsiClass sourceClass;
        Set unitSet = sourceElement == null || (sourceClass = PsiTreeUtil.getParentOfType(sourceElement, PsiClass.class, false)) == null ? null : (Set)PersistenceCommonUtil.getAllPersistenceUnits(sourceClass, sourceType, new THashSet());
        return PersistenceCommonUtil.createUnitsAndTypeMapper(unitSet, type);
    }

    public static PersistenceModelBrowser createSameUnitsModelBrowser(DomElement sourceDom, PersistenceClassRoleEnum type) {
        Object rootElement;
        THashSet unitSet = sourceDom == null || !((rootElement = sourceDom.getRoot().getRootElement()) instanceof PersistenceMappings) ? null : new THashSet(PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits((PersistenceMappings)rootElement));
        return PersistenceCommonUtil.createUnitsAndTypeMapper(unitSet, type);
    }

    public static PersistenceModelBrowser createUnitsAndTypeMapper(final Set<PersistencePackage> unitSet, final PersistenceClassRoleEnum type) {
        return PersistenceHelper.getHelper().createModelBrowser().setRoleFilter(new Condition<PersistenceClassRole>(){

            @Override
            public boolean value(PersistenceClassRole role) {
                PersistentObject object = role.getPersistentObject();
                PersistenceClassRoleEnum roleType = role.getType();
                return !(roleType == PersistenceClassRoleEnum.ENTITY_LISTENER || object == null || type != null && roleType != type || unitSet != null && !unitSet.contains(role.getPersistenceUnit()));
            }
        });
    }

    public static PersistenceModelBrowser createFacetAndUnitModelBrowser(final PersistenceFacetBase facet, final PersistencePackage unit, final PersistenceClassRoleEnum type) {
        return PersistenceHelper.getHelper().createModelBrowser().setRoleFilter(new Condition<PersistenceClassRole>(){

            @Override
            public boolean value(PersistenceClassRole role) {
                PersistentObject object = role.getPersistentObject();
                return !(object == null || type != null && role.getType() != type || unit != null && !unit.equals(role.getPersistenceUnit()) || facet != null && !facet.equals(role.getFacet()));
            }
        });
    }

    @Nullable
    public static PsiType getTargetEntityType(PsiMember psiMember) {
        return PersistenceCommonUtil.getTargetEntityType(PropertyUtil.getPropertyType(psiMember));
    }

    @Nullable
    public static PsiType getTargetEntityType(PsiType type) {
        Pair<JavaContainerType, PsiType> containerType = PersistenceCommonUtil.getContainerType(type);
        return containerType.getSecond();
    }

    public static <T extends Collection<PersistencePackage>> T getAllPersistenceUnits(PsiClass sourceClass, PersistenceClassRoleEnum type, T result) {
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(sourceClass)) {
            if (type != null && role.getType() != type) continue;
            ContainerUtil.addIfNotNull(role.getPersistenceUnit(), result);
        }
        return result;
    }

    public static PersistenceClassRole[] getPersistenceRoles(PsiClass aClass) {
        if (aClass == null) {
            return PersistenceClassRole.EMPTY_ARRAY;
        }
        return PersistenceRoleHolder.getInstance(aClass.getProject()).getRoles(aClass);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T extends PersistencePackage, V extends PersistenceMappings> Collection<V> getDomEntityMappings(Class<V> mappingsClass, T unit, PersistenceFacetBase<?, T> facet) {
        THashSet result = new THashSet();
        for (PersistenceMappings persistenceMappings : facet.getDefaultEntityMappings(unit)) {
            if (!ReflectionCache.isAssignable(mappingsClass, persistenceMappings.getClass())) continue;
            result.add((Object)persistenceMappings);
        }
        for (GenericValue genericValue : unit.getModelHelper().getMappingFiles(mappingsClass)) {
            ContainerUtil.addIfNotNull(genericValue.getValue(), result);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/persistence/util/PersistenceCommonUtil.getDomEntityMappings must not return null");
        }
        return tHashSet;
    }

    public static boolean isSameTable(TableInfoProvider table1, TableInfoProvider table2) {
        if (table1 == null || table2 == null) {
            return false;
        }
        String name1 = table1.getTableName().getValue();
        return StringUtil.isNotEmpty(name1) && Comparing.equal(name1, table2.getTableName().getValue()) && Comparing.equal(table1.getSchema().getValue(), table2.getSchema().getValue()) && Comparing.equal(table1.getCatalog().getValue(), table2.getCatalog().getValue());
    }

    public static String getUniqueId(PsiElement psiElement) {
        VirtualFile virtualFile = psiElement == null ? null : PsiUtil.getVirtualFile(psiElement);
        return virtualFile == null ? "" : virtualFile.getUrl();
    }

    public static String getMultiplicityString(boolean optional, boolean many) {
        String first = optional ? "0" : "1";
        String last = many ? "*" : "1";
        return first.equals(last) ? first : first + ".." + last;
    }

    public static <T, V extends Collection<T>> V mapPersistenceRoles(V result, Project project, PersistenceFacetBase facet, PersistencePackage unit, Function<PersistenceClassRole, T> mapper) {
        Collection<PersistenceClassRole> allRoles = PersistenceRoleHolder.getInstance(project).getClassRoleManager().getUserData(PersistenceRoleHolder.PERSISTENCE_CLASS_ROLES_KEY, PersistenceRoleHolder.PERSISTENCE_ALL_ROLES_DATA_KEY);
        if (allRoles != null) {
            for (PersistenceClassRole role : allRoles) {
                if (facet != null && facet != role.getFacet() || unit != null && unit != role.getPersistenceUnit()) continue;
                ContainerUtil.addIfNotNull(mapper.fun(role), result);
            }
        }
        return result;
    }

    public static boolean haveCorrespondingMultiplicity(PersistentRelationshipAttribute a1, PersistentRelationshipAttribute a2) {
        return a1.getAttributeModelHelper().getRelationshipType().corresponds(a2.getAttributeModelHelper().getRelationshipType());
    }

    public static <T extends PersistencePackage> boolean processNamedQueries(PersistenceFacetBase<?, T> facet, boolean nativeQueries, Processor<PersistenceQuery> processor) {
        return PersistenceCommonUtil.processNamedQueries(nativeQueries ? PersistenceRoleHolder.PERSISTENCE_ALL_NATIVE_QUERIES_DATA_KEY : PersistenceRoleHolder.PERSISTENCE_ALL_QUERIES_DATA_KEY, facet, processor);
    }

    private static <T extends PersistencePackage> boolean processNamedQueries(Key<Map<PersistenceFacetBase, Collection<PersistenceQuery>>> queriesDataKey, PersistenceFacetBase<?, T> facet, Processor<PersistenceQuery> processor) {
        Collection<PersistenceQuery> queries;
        Map<PersistenceFacetBase, Collection<PersistenceQuery>> namedQueriesMap = PersistenceRoleHolder.getInstance(facet.getModule().getProject()).getClassRoleManager().getUserData(PersistenceRoleHolder.PERSISTENCE_CLASS_ROLES_KEY, queriesDataKey);
        return namedQueriesMap == null || (queries = namedQueriesMap.get(facet)) == null || ContainerUtil.process(queries, processor);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Pair<JavaContainerType, PsiType> getContainerType(PsiType type) {
        PsiClassType.ClassResolveResult classResolveResult;
        Pair<JavaContainerType, Object> pair;
        if (type instanceof PsiArrayType) {
            pair = Pair.create(JavaContainerType.ARRAY, ((PsiArrayType)type).getComponentType());
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/persistence/util/PersistenceCommonUtil.getContainerType must not return null");
            return pair;
        }
        PsiClassType.ClassResolveResult classResolveResult2 = classResolveResult = type instanceof PsiClassType ? ((PsiClassType)type).resolveGenerics() : null;
        if (classResolveResult == null) {
            pair = Pair.create(null, type);
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/persistence/util/PersistenceCommonUtil.getContainerType must not return null");
            return pair;
        }
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            pair = Pair.create(null, type);
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/persistence/util/PersistenceCommonUtil.getContainerType must not return null");
            return pair;
        }
        PsiManager manager = psiClass.getManager();
        GlobalSearchScope scope = manager.getProject().getAllScope();
        for (JavaContainerType collectionType : JavaContainerType.values()) {
            void var11_13;
            PsiClass aClass;
            if (collectionType == JavaContainerType.ARRAY || (aClass = manager.findClass(collectionType.getJavaBaseClassName(), scope)) == null || !manager.areElementsEquivalent(aClass, psiClass) && !psiClass.isInheritor(aClass, true)) continue;
            PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
            assert (!PsiUtil.getLanguageLevel(aClass).hasEnumKeywordAndAutoboxing() || typeParameters.length > 0);
            if (typeParameters.length > 0) {
                PsiType psiType = TypeConversionUtil.getSuperClassSubstitutor(aClass, psiClass, classResolveResult.getSubstitutor()).substitute(typeParameters[typeParameters.length - 1]);
            } else {
                PsiClassType psiClassType = PsiType.getJavaLangObject(manager, scope);
            }
            if ((pair = Pair.create(collectionType, var11_13)) == null) throw new IllegalStateException("@NotNull method com/intellij/persistence/util/PersistenceCommonUtil.getContainerType must not return null");
            return pair;
        }
        pair = Pair.create(null, type);
        if (pair != null) return pair;
        throw new IllegalStateException("@NotNull method com/intellij/persistence/util/PersistenceCommonUtil.getContainerType must not return null");
    }

    public static Query<PersistentObject> queryPersistentObjects(PersistenceMappings mappings) {
        return new ExecutorsQuery(mappings, Collections.singletonList(new QueryExecutor<PersistentObject, PersistenceMappings>(){

            @Override
            public boolean execute(PersistenceMappings queryParameters, Processor<PersistentObject> consumer) {
                if (!ContainerUtil.process(queryParameters.getModelHelper().getPersistentEntities(), consumer)) {
                    return false;
                }
                if (!ContainerUtil.process(queryParameters.getModelHelper().getPersistentSuperclasses(), consumer)) {
                    return false;
                }
                return ContainerUtil.process(queryParameters.getModelHelper().getPersistentEmbeddables(), consumer);
            }
        }));
    }

    @Nullable
    public static PsiClass getTargetClass(PersistentRelationshipAttribute attribute) {
        PsiType entityType;
        GenericValue<PsiClass> classValue = attribute.getTargetEntityClass();
        PsiClass targetClass = classValue.getStringValue() != null ? classValue.getValue() : ((entityType = PersistenceCommonUtil.getTargetEntityType(attribute.getPsiMember())) instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null);
        return targetClass;
    }

    @Nullable
    public static PsiClass getTargetClass(PersistentEmbeddedAttribute attribute) {
        PsiType entityType;
        GenericValue<PsiClass> classValue = attribute.getTargetEmbeddableClass();
        PsiClass targetClass = classValue.getStringValue() != null ? classValue.getValue() : ((entityType = PropertyUtil.getPropertyType(attribute.getPsiMember())) instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null);
        return targetClass;
    }
}

