/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaContainerType {
    MAP,
    SET,
    LIST,
    COLLECTION,
    ARRAY;


    public String getJavaBaseClassName() {
        switch (this) {
            case ARRAY: {
                return "java.lang.reflect.Array";
            }
            case COLLECTION: {
                return "java.util.Collection";
            }
            case LIST: {
                return "java.util.List";
            }
            case MAP: {
                return "java.util.Map";
            }
            case SET: {
                return "java.util.Set";
            }
        }
        throw new AssertionError();
    }

    public boolean isCollection() {
        return this == LIST || this == SET || this == COLLECTION;
    }

    public PsiType createCollectionType(PsiElement context, PsiType elementType, PsiType mapKeyType) throws IncorrectOperationException {
        return context.getManager().getElementFactory().createTypeFromText(this.getCollectionTypeText(PsiUtil.getLanguageLevel(context).hasEnumKeywordAndAutoboxing(), elementType.getCanonicalText(), mapKeyType == null ? null : mapKeyType.getCanonicalText()), context);
    }

    public String getCollectionTypeText(boolean useGenerics, String elementTypeName, String mapKeyType) {
        String text;
        switch (this) {
            case ARRAY: {
                text = elementTypeName + "[]";
                break;
            }
            case COLLECTION: {
                text = "java.util.Collection" + (!useGenerics ? "" : "<" + elementTypeName + ">");
                break;
            }
            case LIST: {
                text = "java.util.List" + (!useGenerics ? "" : "<" + elementTypeName + ">");
                break;
            }
            case MAP: {
                text = "java.util.Map" + (!useGenerics ? "" : "<" + (mapKeyType == null ? "java.lang.Object" : mapKeyType) + ", " + elementTypeName + ">");
                break;
            }
            case SET: {
                text = "java.util.Set" + (!useGenerics ? "" : "<" + elementTypeName + ">");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return text;
    }
}

