/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.roles;

import com.intellij.javaee.model.role.ClassRoleManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.persistence.facet.PersistenceFacetBase;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PersistenceRoleHolder {
    public static final Key<PersistenceClassRole> PERSISTENCE_CLASS_ROLES_KEY = Key.create("PERSISTENCE_CLASS_ROLES_KEY");
    public static final Key<Collection<PersistenceClassRole>> PERSISTENCE_ALL_ROLES_DATA_KEY = Key.create("PERSISTENCE_ALL_ROLES_DATA_KEY");
    public static final Key<Map<PersistenceFacetBase, Collection<PersistenceQuery>>> PERSISTENCE_ALL_QUERIES_DATA_KEY = Key.create("PERSISTENCE_ALL_QUERIES_DATA_KEY");
    public static final Key<Map<PersistenceFacetBase, Collection<PersistenceQuery>>> PERSISTENCE_ALL_NATIVE_QUERIES_DATA_KEY = Key.create("PERSISTENCE_ALL_NATIVE_QUERIES_DATA_KEY");

    public static PersistenceRoleHolder getInstance(Project project) {
        return ServiceManager.getService(project, PersistenceRoleHolder.class);
    }

    @NotNull
    public abstract ClassRoleManager getClassRoleManager();

    @NotNull
    public abstract PersistenceClassRole[] getRoles(PsiClass var1);

    @NotNull
    public abstract PersistenceClassRole[] getRolesNoRebuild(PsiClass var1);

    public abstract void resetRoles();
}

