/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.model.manipulators;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.PrimaryKey;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceAction<V extends PersistenceManipulator>
implements PersistenceAction {
    private final Presentation myPresentation;
    private final V myManipulator;
    private final String myActionName;

    public AbstractPersistenceAction(V manipulator, String actionName, String actionTitle, Icon icon) {
        this.myManipulator = manipulator;
        this.myActionName = actionName;
        this.myPresentation = new Presentation();
        this.myPresentation.setText(actionTitle);
        this.myPresentation.setIcon(icon);
    }

    public V getManipulator() {
        return this.myManipulator;
    }

    @Override
    public Object getActionKey() {
        return this.getActionName();
    }

    @Override
    @PrimaryKey
    @NameValue
    public String getActionName() {
        return this.myActionName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Presentation getPresentation() {
        Presentation presentation = this.myPresentation;
        if (presentation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/persistence/model/manipulators/AbstractPersistenceAction.getPresentation must not return null");
        }
        return presentation;
    }

    @Override
    @Nullable
    public PersistenceManipulator getActiveManipulator() {
        return this.getPresentation().isEnabled() ? (PersistenceManipulator)this.getManipulator() : null;
    }

    @Override
    public void update(AnActionEvent e) {
    }

    @Override
    public boolean preInvoke(UserResponse response) {
        return true;
    }

    @Override
    public final void putTargetElement(Map<PersistenceAction, PsiElement> targetMap) {
        PsiElement targetElement = this.getTargetElement();
        if (targetElement != null) {
            assert (!targetMap.containsValue(targetElement)) : "target element locked";
            targetMap.put(this, targetElement);
        }
    }

    @Override
    public boolean postInvoke(PersistenceAction action, UserResponse response) {
        return true;
    }

    @Nullable
    protected abstract PsiElement getTargetElement();

    @Override
    public abstract void invokeAction(@NotNull Collection<PsiElement> var1) throws IncorrectOperationException;
}

