/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelationshipType {
    ONE_TO_ONE,
    ONE_TO_MANY,
    MANY_TO_ONE,
    MANY_TO_MANY;


    public boolean isMany(boolean thisSide) {
        switch (this) {
            case MANY_TO_MANY: {
                return true;
            }
            case MANY_TO_ONE: {
                return thisSide;
            }
            case ONE_TO_MANY: {
                return !thisSide;
            }
            case ONE_TO_ONE: {
                return false;
            }
        }
        return false;
    }

    public RelationshipType getInverseType() {
        switch (this) {
            case MANY_TO_MANY: {
                return this;
            }
            case MANY_TO_ONE: {
                return ONE_TO_MANY;
            }
            case ONE_TO_MANY: {
                return MANY_TO_ONE;
            }
            case ONE_TO_ONE: {
                return this;
            }
        }
        return null;
    }

    public boolean corresponds(RelationshipType otherSideType) {
        return this.getInverseType() == otherSideType;
    }

    public static RelationshipType getRelationshipType(boolean thatSideMany, boolean thisSideMany) {
        return thisSideMany ? (thatSideMany ? MANY_TO_MANY : MANY_TO_ONE) : (thatSideMany ? ONE_TO_MANY : ONE_TO_ONE);
    }
}

