/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.diagram;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.view.DefaultUserResponse;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.jam.view.tree.JamObjectDescriptor;
import com.intellij.javaee.model.common.CommonModelElement;
import com.intellij.javaee.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.diagram.PersistenceDiagram;
import com.intellij.persistence.diagram.PersistenceDiagramSupport;
import com.intellij.persistence.facet.PersistenceFacetBase;
import com.intellij.persistence.facet.PersistenceFacetConfiguration;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDiagramSupport
implements PersistenceDiagramSupport<PersistencePackage, PersistentObject, PersistentAttribute> {
    private Map<PsiClass, PersistentObject> myClassMap;
    private Collection<PersistentObject> myPersistentObjects;
    private final PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage> myFacet;
    private PersistenceModelBrowser myModelBrowser;

    public DefaultDiagramSupport(PersistenceFacetBase<PersistenceFacetConfiguration, PersistencePackage> facet) {
        this.myFacet = facet;
    }

    public PersistenceFacetBase getModificationTracker(PersistencePackage unit) {
        return this.myFacet;
    }

    @Override
    public void startDataModelUpdate(PersistencePackage persistencePackage) {
        this.myModelBrowser = PersistenceCommonUtil.createFacetAndUnitModelBrowser(this.myFacet, persistencePackage, null);
        if (persistencePackage == null || !persistencePackage.isValid()) {
            this.myPersistentObjects = Collections.emptyList();
            this.myClassMap = Collections.emptyMap();
        } else {
            PersistenceMappings entityMappings = this.myFacet.getEntityMappings(persistencePackage);
            this.startDataModelUpdate(entityMappings);
        }
    }

    @Override
    public void startDataModelUpdate(PersistenceMappings entityMappings) {
        this.myPersistentObjects = PersistenceCommonUtil.queryPersistentObjects(entityMappings).findAll();
        this.myClassMap = new THashMap();
        for (PersistentObject persistentObject : this.myPersistentObjects) {
            PsiClass psiClass = persistentObject.getClazz().getValue();
            if (psiClass == null) continue;
            this.myClassMap.put(psiClass, persistentObject);
        }
    }

    @Override
    public void finishDataModelUpdate() {
        this.myPersistentObjects = null;
        this.myClassMap = null;
    }

    public PersistenceModelBrowser getModelBrowser() {
        return this.myModelBrowser;
    }

    @Override
    public void processEntities(PairProcessor<? super PersistentObject, String> pairProcessor) {
        Iterator<PersistentObject> i$ = this.myPersistentObjects.iterator();
        while (i$.hasNext()) {
            PersistentObject object;
            PsiClass psiClass = (object = i$.next()).getClazz().getValue();
            if (pairProcessor.process(object, psiClass == null ? object.getClazz().getStringValue() : psiClass.getQualifiedName())) continue;
            return;
        }
    }

    @Override
    public void processSuper(PersistentObject sourceEntity, PairProcessor<? super PersistentObject, String> pairProcessor) {
        PsiClass psiClass = sourceEntity.getClazz().getValue();
        if (psiClass == null) {
            return;
        }
        for (PsiClass curClass : JamCommonUtil.getSuperClassList(psiClass.getSuperClass())) {
            PersistentObject superObject = this.myClassMap.get(curClass);
            if (superObject == null || pairProcessor.process(superObject, curClass.getQualifiedName())) continue;
            return;
        }
    }

    @Override
    public void processRelated(PersistentObject sourceEntity, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : sourceEntity.getObjectModelHelper().getAttributes()) {
            PersistentRelationshipAttribute attribute;
            PsiClass psiClass;
            if (!(persistentAttribute instanceof PersistentRelationshipAttribute) || pairProcessor.process(persistentAttribute, (psiClass = PersistenceCommonUtil.getTargetClass(attribute = (PersistentRelationshipAttribute)persistentAttribute)) == null ? attribute.getTargetEntityClass().getStringValue() : psiClass.getQualifiedName())) continue;
            return;
        }
    }

    @Override
    public void processEmbedded(PersistentObject sourceEntity, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : sourceEntity.getObjectModelHelper().getAttributes()) {
            PersistentEmbeddedAttribute attribute;
            PsiClass psiClass;
            if (!(persistentAttribute instanceof PersistentEmbeddedAttribute) || pairProcessor.process(persistentAttribute, (psiClass = PersistenceCommonUtil.getTargetClass(attribute = (PersistentEmbeddedAttribute)persistentAttribute)) == null ? attribute.getTargetEmbeddableClass().getStringValue() : psiClass.getQualifiedName())) continue;
            return;
        }
    }

    @Override
    public void processAttributes(PersistentObject persistentObject, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : persistentObject.getObjectModelHelper().getAttributes()) {
            if (persistentAttribute instanceof PersistentTransientAttribute || persistentAttribute instanceof PersistentRelationshipAttribute || persistentAttribute instanceof PersistentEmbeddedAttribute || pairProcessor.process(persistentAttribute, persistentAttribute.getName().getValue())) continue;
            return;
        }
    }

    @Override
    @Nullable
    public PersistentObject getAttributeTarget(PersistentAttribute persistentAttribute) {
        if (persistentAttribute instanceof PersistentRelationshipAttribute) {
            return this.myModelBrowser.queryTargetPersistentObjects((PersistentRelationshipAttribute)persistentAttribute).findFirst();
        }
        if (persistentAttribute instanceof PersistentEmbeddedAttribute) {
            return this.myModelBrowser.queryTargetPersistentObjects((PersistentEmbeddedAttribute)persistentAttribute).findFirst();
        }
        return null;
    }

    @Override
    public String getUniqueId(PersistentObject persistentObject) {
        return PersistenceCommonUtil.getUniqueId(persistentObject == null ? null : persistentObject.getIdentifyingPsiElement());
    }

    @Override
    @Nullable
    public PersistentAttribute getInverseSideAttribute(PersistentAttribute persistentAttribute) {
        assert (persistentAttribute instanceof PersistentRelationshipAttribute);
        return this.myModelBrowser.queryTheOtherSideAttributes((PersistentRelationshipAttribute)persistentAttribute, false).findFirst();
    }

    @Override
    @Nullable
    public String getAttributeName(PersistentAttribute persistentAttribute) {
        return persistentAttribute.getName().getValue();
    }

    @Override
    @Nullable
    public PsiType getAttributePsiType(PersistentAttribute persistentAttribute) {
        return persistentAttribute.getPsiType();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NonNls
    @NotNull
    public String getEntityTypeName(PersistentObject persistentObject) {
        String string = ElementPresentationManager.getTypeNameForObject(persistentObject);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/persistence/diagram/DefaultDiagramSupport.getEntityTypeName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NonNls
    @NotNull
    public String getAttributeTypeName(PersistentAttribute persistentAttribute) {
        String string = ElementPresentationManager.getTypeNameForObject(persistentAttribute);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/persistence/diagram/DefaultDiagramSupport.getAttributeTypeName must not return null");
        }
        return string;
    }

    @Override
    public boolean isIdAttribute(PersistentAttribute persistentAttribute) {
        return persistentAttribute.getAttributeModelHelper().isIdAttribute();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getAttributeMultiplicityLabel(PersistentAttribute first, PersistentAttribute second, boolean isSource) {
        assert (first instanceof PersistentRelationshipAttribute && (second == null || second instanceof PersistentRelationshipAttribute));
        PersistentRelationshipAttribute attribute = (PersistentRelationshipAttribute)first;
        boolean many = attribute.getAttributeModelHelper().getRelationshipType().isMany(isSource);
        boolean optional = attribute.getAttributeModelHelper().isRelationshipSideOptional(isSource) && !this.isNotNull((PersistentRelationshipAttribute)second);
        String string = PersistenceCommonUtil.getMultiplicityString(optional, many);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/persistence/diagram/DefaultDiagramSupport.getAttributeMultiplicityLabel must not return null");
        }
        return string;
    }

    private boolean isNotNull(PersistentRelationshipAttribute attribute) {
        PsiMember owner = attribute == null ? null : attribute.getPsiMember();
        return owner != null && AnnotationUtil.isNotNull(owner);
    }

    @Override
    @Nullable
    public Icon getEntityIcon(PersistentObject persistentObject) {
        return ElementPresentationManager.getIcon(persistentObject);
    }

    @Override
    @Nullable
    public Icon getAttributeIcon(PersistentAttribute persistentAttribute) {
        return ElementPresentationManager.getIcon(persistentAttribute);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TypeSafeDataProvider createDataProvider(final PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram) {
        TypeSafeDataProvider typeSafeDataProvider = new TypeSafeDataProvider(){

            public void calcData(DataKey key, DataSink sink) {
                DefaultDiagramSupport.this.getData(diagram, key, sink);
            }
        };
        if (typeSafeDataProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/persistence/diagram/DefaultDiagramSupport.createDataProvider must not return null");
        }
        return typeSafeDataProvider;
    }

    protected boolean getData(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram, DataKey key, DataSink sink) {
        boolean set = false;
        if (DataKeys.PROJECT.equals(key)) {
            set = true;
            sink.put(DataKeys.PROJECT, diagram.getUnit().getPsiManager().getProject());
        } else if (DataKeys.MODULE.equals(key)) {
            set = true;
            sink.put(DataKeys.MODULE, diagram.getUnit().getModule());
        } else if (PersistenceDataKeys.PERSISTENCE_FACET.equals(key)) {
            set = true;
            sink.put(PersistenceDataKeys.PERSISTENCE_FACET, this.myFacet);
        } else if (JamObjectDescriptor.SELECTED_COMMON_MODEL_ELEMENT.equals(key)) {
            CommonModelElement element = diagram.getSelectedEntity() != null ? (CommonModelElement)diagram.getSelectedEntity() : (CommonModelElement)diagram.getUnit();
            set = true;
            sink.put(JamObjectDescriptor.SELECTED_COMMON_MODEL_ELEMENT, element);
        } else if (PersistenceDataKeys.PERSISTENCE_UNIT.equals(key)) {
            set = true;
            sink.put(PersistenceDataKeys.PERSISTENCE_UNIT, diagram.getUnit());
        } else if (DataKeys.PSI_ELEMENT_ARRAY.equals(key)) {
            set = true;
            Collection<CommonModelElement> elements = this.getSelectedElements(diagram);
            if (!elements.isEmpty()) {
                HashSet result = new HashSet();
                for (CommonModelElement element : elements) {
                    PsiElement psiElement = element.getIdentifyingPsiElement();
                    ContainerUtil.addIfNotNull(psiElement, result);
                }
                sink.put(DataKeys.PSI_ELEMENT_ARRAY, result.toArray(new PsiElement[result.size()]));
            }
        } else if (DataKeys.DELETE_ELEMENT_PROVIDER.equals(key)) {
            set = true;
            Collection<CommonModelElement> elements = this.getSelectedElements(diagram);
            if (!elements.isEmpty()) {
                sink.put(DataKeys.DELETE_ELEMENT_PROVIDER, new JamDeleteProvider(new DefaultUserResponse(diagram.getUnit().getPsiManager().getProject()), elements));
            }
        } else if (DataKeys.NAVIGATABLE_ARRAY.equals(key)) {
            set = true;
            Collection<CommonModelElement> elements = this.getSelectedElements(diagram);
            if (!elements.isEmpty()) {
                HashSet<OpenFileDescriptor> result = new HashSet<OpenFileDescriptor>();
                for (CommonModelElement element : elements) {
                    PsiFile containingFile;
                    VirtualFile file;
                    PsiElement psiElement = element.getIdentifyingPsiElement();
                    if (psiElement == null || (file = (containingFile = psiElement.getContainingFile()) == null ? null : containingFile.getVirtualFile()) == null) continue;
                    result.add(new OpenFileDescriptor(psiElement.getProject(), file, psiElement.getTextOffset()));
                }
                sink.put(DataKeys.NAVIGATABLE_ARRAY, result.toArray(new Navigatable[result.size()]));
            }
        }
        return set;
    }

    private Collection<CommonModelElement> getSelectedElements(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram) {
        final HashSet<CommonModelElement> elements = new HashSet<CommonModelElement>();
        diagram.processSelectedNodes(new PairProcessor<PersistentObject, String>(){

            @Override
            public boolean process(PersistentObject persistentObject, String persistentAttribute) {
                ContainerUtil.addIfNotNull(persistentObject, elements);
                return true;
            }
        });
        diagram.processSelectedEdges(new PairProcessor<PersistentObject, PersistentAttribute>(){

            @Override
            public boolean process(PersistentObject persistentObject, PersistentAttribute persistentAttribute) {
                ContainerUtil.addIfNotNull(persistentAttribute, elements);
                if (persistentAttribute instanceof PersistentRelationshipAttribute) {
                    elements.addAll(DefaultDiagramSupport.this.myModelBrowser.queryTheOtherSideAttributes((PersistentRelationshipAttribute)persistentAttribute, false).findAll());
                }
                return true;
            }
        });
        return elements;
    }

    @Override
    public boolean processEditNode(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram, PersistentObject entity) {
        return false;
    }

    @Override
    public boolean processEditEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram) {
        return false;
    }

    @Override
    public void processCreateEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram, PersistentObject sourceEntity, PersistentObject targetEntity) {
    }

    @Override
    public void customizeGraphView(Graph2DView view, EditMode editMode) {
    }
}

