/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusWatcher
implements ContainerListener,
FocusListener {
    private Component myTopComponent;
    private WeakReference<Component> myFocusedComponent;
    private WeakReference<Component> myNearestFocusableComponent;

    public Component getTopComponent() {
        return this.myTopComponent;
    }

    public final void componentAdded(ContainerEvent e) {
        this.installImpl(e.getChild());
    }

    public final void componentRemoved(ContainerEvent e) {
        Component removedChild = e.getChild();
        if (this.getNearestFocusableComponent() != null && SwingUtilities.isDescendingFrom(this.getNearestFocusableComponent(), removedChild)) {
            this.setNearestFocusableComponent(null);
        }
        if (this.getFocusedComponent() != null && SwingUtilities.isDescendingFrom(this.getFocusedComponent(), removedChild)) {
            this.setNearestFocusableComponent(e.getContainer());
        }
        this.deinstall(removedChild, e);
    }

    public final void deinstall(Component component) {
        this.deinstall(component, null);
    }

    public final void deinstall(Component component, @Nullable AWTEvent cause) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                this.deinstall(container.getComponent(i));
            }
            container.removeContainerListener(this);
        }
        component.removeFocusListener(this);
        if (this.getFocusedComponent() == component) {
            this.setFocusedComponentImpl(null, cause);
        }
    }

    public final void focusGained(FocusEvent e) {
        Component component = e.getComponent();
        if (e.isTemporary() || !component.isShowing()) {
            return;
        }
        this.setFocusedComponentImpl(component, e);
        this.setNearestFocusableComponent(component.getParent());
    }

    public final void focusLost(FocusEvent e) {
        Component component = e.getOppositeComponent();
        if (component != null && !SwingUtilities.isDescendingFrom(component, this.myTopComponent)) {
            this.focusLostImpl(e);
        }
    }

    public final Component getFocusedComponent() {
        return this.myFocusedComponent != null ? (Component)this.myFocusedComponent.get() : null;
    }

    public final Component getNearestFocusableComponent() {
        return this.myNearestFocusableComponent != null ? (Component)this.myNearestFocusableComponent.get() : null;
    }

    public final void install(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/FocusWatcher.install must not be null");
        }
        this.myTopComponent = component;
        this.installImpl(component);
    }

    private void installImpl(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                this.installImpl(container.getComponent(i));
            }
            container.addContainerListener(this);
        }
        if (component instanceof JMenuItem || component instanceof JMenuBar) {
            return;
        }
        component.addFocusListener(this);
    }

    public void setFocusedComponentImpl(Component component) {
        this.setFocusedComponentImpl(component, null);
    }

    public void setFocusedComponentImpl(Component component, @Nullable AWTEvent cause) {
        if (!this.isFocusedComponentChangeValid(component, cause)) {
            return;
        }
        this.setFocusedComponent(component);
        this.focusedComponentChanged(component, cause);
    }

    protected boolean isFocusedComponentChangeValid(Component comp, AWTEvent cause) {
        return true;
    }

    protected void focusedComponentChanged(Component component, @Nullable AWTEvent cause) {
    }

    protected void focusLostImpl(FocusEvent e) {
    }

    private void setFocusedComponent(Component focusedComponent) {
        this.myFocusedComponent = new WeakReference<Component>(focusedComponent);
    }

    private void setNearestFocusableComponent(Component nearestFocusableComponent) {
        this.myNearestFocusableComponent = new WeakReference<Component>(nearestFocusableComponent);
    }
}

