/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;

public class VFileMoveEvent
extends VFileEvent {
    private VirtualFile myFile;
    private VirtualFile myOldParent;
    private VirtualFile myNewParent;

    public VFileMoveEvent(Object requestor, VirtualFile file, VirtualFile newParent) {
        super(requestor, false);
        this.myFile = file;
        this.myNewParent = newParent;
        this.myOldParent = file.getParent();
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public VirtualFile getNewParent() {
        return this.myNewParent;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    public String getPath() {
        return this.myFile.getPath();
    }

    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.getParent() == this.myOldParent && this.myOldParent.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myOldParent.hashCode();
        result = 31 * result + this.myNewParent.hashCode();
        return result;
    }
}

