/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;

public class VFileCopyEvent
extends VFileEvent {
    private VirtualFile myFile;
    private VirtualFile myNewParent;
    private String myNewChildName;

    public VFileCopyEvent(Object requestor, VirtualFile file, VirtualFile newParent, String newChildName) {
        super(requestor, false);
        this.myFile = file;
        this.myNewParent = newParent;
        this.myNewChildName = newChildName;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public VirtualFile getNewParent() {
        return this.myNewParent;
    }

    public String getNewChildName() {
        return this.myNewChildName;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[copy " + this.myFile + " to " + this.myNewParent + " as " + this.myNewChildName + "]";
    }

    public String getPath() {
        return this.myNewParent.getPath() + "/" + this.myNewChildName;
    }

    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myNewParent.findChild(this.myNewChildName) == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCopyEvent event = (VFileCopyEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewChildName.equals(event.myNewChildName)) {
            return false;
        }
        return this.myNewParent.equals(event.myNewParent);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myNewParent.hashCode();
        result = 31 * result + this.myNewChildName.hashCode();
        return result;
    }
}

