/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NonNls;

public class VFileContentChangeEvent
extends VFileEvent {
    private VirtualFile myFile;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;

    public VFileContentChangeEvent(Object requestor, VirtualFile file, long oldModificationStamp, long newModificationStamp, boolean isFromRefresh) {
        super(requestor, isFromRefresh);
        this.myFile = file;
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp == -1L ? LocalTimeCounter.currentTime() : newModificationStamp;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public long getModificationStamp() {
        return this.myNewModificationStamp;
    }

    public long getOldModificationStamp() {
        return this.myOldModificationStamp;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[update: " + this.myFile.getUrl() + "]";
    }

    public String getPath() {
        return this.myFile.getPath();
    }

    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.getModificationStamp() == this.myOldModificationStamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileContentChangeEvent event = (VFileContentChangeEvent)o;
        if (this.myNewModificationStamp != event.myNewModificationStamp) {
            return false;
        }
        if (this.myOldModificationStamp != event.myOldModificationStamp) {
            return false;
        }
        return this.myFile.equals(event.myFile);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + (int)(this.myOldModificationStamp ^ this.myOldModificationStamp >>> 32);
        result = 31 * result + (int)(this.myNewModificationStamp ^ this.myNewModificationStamp >>> 32);
        return result;
    }
}

