/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;

public class VirtualFileFilteringListener
implements VirtualFileListener {
    private final VirtualFileListener myDelegate;
    private final VirtualFileSystem myFilter;

    public VirtualFileFilteringListener(VirtualFileListener delegate, VirtualFileSystem filter) {
        this.myDelegate = delegate;
        this.myFilter = filter;
    }

    private boolean isGood(VirtualFileEvent event) {
        return event.getFile().getFileSystem() == this.myFilter;
    }

    public void beforeContentsChange(VirtualFileEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.beforeContentsChange(event);
        }
    }

    public void beforeFileDeletion(VirtualFileEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.beforeFileDeletion(event);
        }
    }

    public void beforeFileMovement(VirtualFileMoveEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.beforeFileMovement(event);
        }
    }

    public void beforePropertyChange(VirtualFilePropertyEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.beforePropertyChange(event);
        }
    }

    public void contentsChanged(VirtualFileEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.contentsChanged(event);
        }
    }

    public void fileCopied(VirtualFileCopyEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.fileCopied(event);
        }
    }

    public void fileCreated(VirtualFileEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.fileCreated(event);
        }
    }

    public void fileDeleted(VirtualFileEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.fileDeleted(event);
        }
    }

    public void fileMoved(VirtualFileMoveEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.fileMoved(event);
        }
    }

    public void propertyChanged(VirtualFilePropertyEvent event) {
        if (this.isGood(event)) {
            this.myDelegate.propertyChanged(event);
        }
    }
}

