/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VirtualFileFilteringListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewVirtualFileSystem
extends VirtualFileSystem
implements FileSystemInterface {
    @NonNls
    private static final String FILE_SEPARATORS = "/" + File.separator;
    private final Map<VirtualFileListener, VirtualFileListener> myListenerWrappers = new HashMap<VirtualFileListener, VirtualFileListener>();

    public abstract boolean isCaseSensitive();

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem.findFileByPath must not be null");
        }
        String normalizedPath = this.normalize(path);
        if (normalizedPath == null) {
            return null;
        }
        String basePath = this.extractRootPath(normalizedPath);
        NewVirtualFile file = ManagingFS.getInstance().findRoot(basePath, this);
        if (file == null || !file.exists()) {
            return null;
        }
        for (String pathElement : StringUtil.tokenize(normalizedPath.substring(basePath.length()), FILE_SEPARATORS)) {
            if (pathElement.length() == 0 || ".".equals(pathElement) || (file = "..".equals(pathElement) ? file.getParent() : file.findChild(pathElement)) != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem.findFileByPathIfCached must not be null");
        }
        String normalizedPath = this.normalize(path);
        if (normalizedPath == null) {
            return null;
        }
        String basePath = this.extractRootPath(normalizedPath);
        NewVirtualFile file = ManagingFS.getInstance().findRoot(basePath, this);
        if (file == null || !file.exists()) {
            return null;
        }
        for (String pathElement : StringUtil.tokenize(normalizedPath.substring(basePath.length()), FILE_SEPARATORS)) {
            if (pathElement.length() == 0 || ".".equals(pathElement) || (file = "..".equals(pathElement) ? file.getParent() : file.findChildIfCached(pathElement)) != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(String path) {
        String normalizedPath = this.normalize(path);
        if (normalizedPath == null) {
            return null;
        }
        String basePath = this.extractRootPath(normalizedPath);
        NewVirtualFile file = ManagingFS.getInstance().findRoot(basePath, this);
        if (file == null || !file.exists()) {
            return null;
        }
        for (String pathElement : StringUtil.tokenize(normalizedPath.substring(basePath.length()), FILE_SEPARATORS)) {
            if (pathElement.length() == 0 || ".".equals(pathElement) || (file = "..".equals(pathElement) ? file.getParent() : file.refreshAndFindChild(pathElement)) != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    protected String normalize(String path) {
        return path;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        this.refresh(asynchronous);
    }

    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots(this));
    }

    public boolean isReadOnly() {
        return true;
    }

    protected abstract String extractRootPath(@NotNull String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVirtualFileListener(VirtualFileListener listener) {
        Map<VirtualFileListener, VirtualFileListener> map = this.myListenerWrappers;
        synchronized (map) {
            VirtualFileFilteringListener wrapper = new VirtualFileFilteringListener(listener, this);
            VirtualFileManager.getInstance().addVirtualFileListener(wrapper);
            this.myListenerWrappers.put(listener, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVirtualFileListener(VirtualFileListener listener) {
        Map<VirtualFileListener, VirtualFileListener> map = this.myListenerWrappers;
        synchronized (map) {
            VirtualFileListener wrapper = this.myListenerWrappers.remove(listener);
            if (wrapper != null) {
                VirtualFileManager.getInstance().removeVirtualFileListener(wrapper);
            }
        }
    }

    public abstract int getRank();

    public abstract VirtualFile copyFile(Object var1, VirtualFile var2, VirtualFile var3, String var4) throws IOException;

    public abstract VirtualFile createChildDirectory(Object var1, VirtualFile var2, String var3) throws IOException;

    public abstract VirtualFile createChildFile(Object var1, VirtualFile var2, String var3) throws IOException;

    public abstract void deleteFile(Object var1, VirtualFile var2) throws IOException;

    public abstract void moveFile(Object var1, VirtualFile var2, VirtualFile var3) throws IOException;

    public abstract void renameFile(Object var1, VirtualFile var2, String var3) throws IOException;

    public boolean markNewFilesAsDirty() {
        return false;
    }

    public String getCanonicallyCasedName(VirtualFile file) {
        return file.getName();
    }
}

