/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FileAttribute {
    private static final Logger LOG = Logger.getInstance("#com.intellij.vfs.FileAttribute");
    private static final Set<String> ourRegisteredIds = new HashSet<String>();
    private final String myId;
    private final int myVersion;

    public FileAttribute(@NonNls String id, int version) {
        this.myId = id;
        this.myVersion = version;
        assert (ourRegisteredIds.add(id)) : "Attribute id='" + id + "' is not unique";
    }

    @Nullable
    public DataInputStream readAttribute(VirtualFile file) {
        FileAttribute.ensureFileIsValid(file);
        DataInputStream stream = ManagingFS.getInstance().readAttribute(file, this);
        if (stream != null) {
            try {
                int actualVersion = stream.readInt();
                if (actualVersion != this.myVersion) {
                    stream.close();
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return stream;
    }

    private static void ensureFileIsValid(VirtualFile file) {
        int id = ((NewVirtualFile)file).getId();
        if (id <= 0) {
            throw new InvalidVirtualFileAccessException(file);
        }
    }

    public DataOutputStream writeAttribute(VirtualFile file) {
        FileAttribute.ensureFileIsValid(file);
        DataOutputStream stream = ManagingFS.getInstance().writeAttribute(file, this);
        try {
            stream.writeInt(this.myVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] readAttributeBytes(VirtualFile file) throws IOException {
        DataInputStream stream = this.readAttribute(file);
        if (stream == null) {
            return null;
        }
        try {
            int len = stream.readInt();
            byte[] byArray = FileUtil.loadBytes(stream, len);
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    public void writeAttributeBytes(VirtualFile file, byte[] bytes) throws IOException {
        this.writeAttributeBytes(file, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAttributeBytes(VirtualFile file, byte[] bytes, int offset, int len) throws IOException {
        DataOutputStream stream = this.writeAttribute(file);
        try {
            stream.writeInt(len);
            stream.write(bytes, offset, len);
        }
        finally {
            stream.close();
        }
    }

    public String getId() {
        return this.myId;
    }
}

