/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.annotations.NotNull;

public class VirtualFileMoveEvent
extends VirtualFileEvent {
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    public VirtualFileMoveEvent(Object requestor, VirtualFile file, VirtualFile oldParent, VirtualFile newParent) {
        super(requestor, file, file.getName(), file.getParent());
        this.myOldParent = oldParent;
        this.myNewParent = newParent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile getOldParent() {
        VirtualFile virtualFile = this.myOldParent;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileMoveEvent.getOldParent must not return null");
        }
        return virtualFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile = this.myNewParent;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileMoveEvent.getNewParent must not return null");
        }
        return virtualFile;
    }
}

