/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.VfsUtil");
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String JAR = "jar";
    @NonNls
    private static final String MAILTO = "mailto";
    private static final String PROTOCOL_DELIMITER = ":";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(VirtualFile file) throws IOException {
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        try {
            String string = new String(FileUtil.loadText(reader, (int)file.getLength()));
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void saveText(VirtualFile file, String text) throws IOException {
        file.setBinaryContent(text.getBytes(file.getCharset().name()));
    }

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.isAncestor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.isAncestor must not be null");
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static String getRelativePath(VirtualFile file, VirtualFile ancestor, char separator) {
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getName().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            String name = parent.getName();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return new String(chars);
    }

    public static void copyDirectory(Object requestor, VirtualFile fromDir, VirtualFile toDir, @Nullable VirtualFileFilter filter) throws IOException {
        VirtualFile[] children;
        for (VirtualFile child : children = fromDir.getChildren()) {
            if (filter != null && !filter.accept(child)) continue;
            if (!child.isDirectory()) {
                VfsUtil.copyFile(requestor, child, toDir);
                continue;
            }
            VirtualFile newChild = toDir.createChildDirectory(requestor, child.getName());
            VfsUtil.copyDirectory(requestor, child, newChild, filter);
        }
    }

    public static VirtualFile copyFile(Object requestor, VirtualFile file, VirtualFile toDir) throws IOException {
        return VfsUtil.copyFile(requestor, file, toDir, file.getName());
    }

    public static VirtualFile copyFile(Object requestor, VirtualFile file, VirtualFile toDir, @NonNls String newName) throws IOException {
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray());
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromResource(VirtualFile file, @NonNls String resourceUrl) throws IOException {
        InputStream out = VfsUtil.class.getResourceAsStream(resourceUrl);
        if (out == null) {
            throw new FileNotFoundException(resourceUrl);
        }
        try {
            byte[] bytes = FileUtil.adaptiveLoadBytes(out);
            file.setBinaryContent(bytes);
        }
        finally {
            out.close();
        }
    }

    public static VirtualFile[] getCommonAncestors(VirtualFile[] files) {
        HashMap<VirtualFile, Object> map = new HashMap<VirtualFile, Object>();
        for (VirtualFile aFile : files) {
            Object filesSet;
            VirtualFile directory;
            VirtualFile virtualFile = directory = aFile.isDirectory() ? aFile : aFile.getParent();
            if (directory == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] path = VfsUtil.getPathComponents(directory);
            VirtualFile firstPart = path[0];
            if (map.containsKey(firstPart)) {
                filesSet = (Set)map.get(firstPart);
            } else {
                filesSet = new THashSet();
                map.put(firstPart, filesSet);
            }
            filesSet.add(directory);
        }
        ArrayList<VirtualFile> ancestorsList = new ArrayList<VirtualFile>();
        for (Set filesSet : map.values()) {
            VirtualFile ancestor = null;
            for (VirtualFile file : filesSet) {
                if (ancestor == null) {
                    ancestor = file;
                    continue;
                }
                ancestor = VfsUtil.getCommonAncestor(ancestor, file);
            }
            ancestorsList.add(ancestor);
            filesSet.clear();
        }
        return ancestorsList.toArray(new VirtualFile[ancestorsList.size()]);
    }

    public static VirtualFile getCommonAncestor(VirtualFile file1, VirtualFile file2) {
        VirtualFile[] maxLengthPath;
        VirtualFile[] minLengthPath;
        VirtualFile[] path2;
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        VirtualFile[] path1 = VfsUtil.getPathComponents(file1);
        if (path1.length < (path2 = VfsUtil.getPathComponents(file2)).length) {
            minLengthPath = path1;
            maxLengthPath = path2;
        } else {
            minLengthPath = path2;
            maxLengthPath = path1;
        }
        int lastEqualIdx = -1;
        int i = 0;
        while (i < minLengthPath.length && minLengthPath[i].equals(maxLengthPath[i])) {
            lastEqualIdx = i++;
        }
        return lastEqualIdx != -1 ? minLengthPath[lastEqualIdx] : null;
    }

    private static VirtualFile[] getPathComponents(VirtualFile file) {
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)componentsList.get(size - i - 1);
        }
        return components;
    }

    @Nullable
    public static VirtualFile findRelativeFile(String uri, VirtualFile base) {
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        uri = ExternalResourceManager.getInstance().getResourceLocation(uri);
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:")) {
            uri = uri.substring("file:".length());
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (!SystemInfo.isWindows && StringUtil.startsWithChar(uri, '/')) {
            file = LocalFileSystem.getInstance().findFileByPath(uri);
        } else if (SystemInfo.isWindows && uri.length() >= 2 && Character.isLetter(uri.charAt(0)) && uri.charAt(1) == ':') {
            file = LocalFileSystem.getInstance().findFileByPath(uri);
        }
        if (file == null && uri.indexOf("!/") != -1) {
            file = JarFileSystem.getInstance().findFileByPath(uri);
        }
        if (file == null) {
            if (base == null) {
                return LocalFileSystem.getInstance().findFileByPath(uri);
            }
            if (!base.isDirectory()) {
                base = base.getParent();
            }
            if (base == null) {
                return LocalFileSystem.getInstance().findFileByPath(uri);
            }
            file = VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + "/" + uri);
            if (file == null) {
                return null;
            }
        }
        return file;
    }

    public static VirtualFile findFileByURL(URL url) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        return VfsUtil.findFileByURL(url, virtualFileManager);
    }

    public static VirtualFile findFileByURL(URL url, VirtualFileManager virtualFileManager) {
        String vfUrl = VfsUtil.convertFromUrl(url);
        return virtualFileManager.findFileByUrl(vfUrl);
    }

    @Nullable
    public static URL convertToURL(String vfsUrl) {
        if (vfsUrl.startsWith(JAR)) {
            LOG.error("jar: protocol not supported.");
            return null;
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split = vfsUrl.split("://");
        if (split.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split[0];
        String path = split[1];
        try {
            if (protocol.equals(FILE)) {
                return new URL(protocol, "", path);
            }
            return new URL(vfsUrl);
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occured:" + e.getMessage());
            return null;
        }
    }

    private static String convertFromUrl(URL url) {
        String protocol = url.getProtocol();
        String path = url.getPath();
        if (protocol.equals(JAR)) {
            if (path.startsWith("file:")) {
                try {
                    URL subURL = new URL(path);
                    path = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(VfsBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(VfsBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (path.charAt(0) == '/') {
                path = path.substring(1, path.length());
            }
        }
        path = StringUtil.replace(path, "%20", " ");
        return protocol + "://" + path;
    }

    public static String urlToPath(@NonNls String url) {
        if (url == null) {
            return "";
        }
        return VirtualFileManager.extractPath(url);
    }

    public static String pathToUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.pathToUrl must not be null");
        }
        return VirtualFileManager.constructUrl(FILE, path);
    }

    public static File virtualToIoFile(VirtualFile file) {
        return new File(PathUtil.toPresentableUrl(file.getUrl()));
    }

    public static IFile virtualToIFile(VirtualFile file) {
        return FileSystem.FILE_SYSTEM.createFile(PathUtil.toPresentableUrl(file.getUrl()));
    }

    public static VirtualFile copyFileRelative(Object requestor, VirtualFile file, VirtualFile toDir, String relativePath) throws IOException {
        String token;
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        VirtualFile curDir = toDir;
        while (true) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) break;
            VirtualFile childDir = curDir.findChild(token);
            if (childDir == null) {
                childDir = curDir.createChildDirectory(requestor, token);
            }
            curDir = childDir;
        }
        return VfsUtil.copyFile(requestor, file, curDir, token);
    }

    public static String fixIDEAUrl(String ideaUrl) {
        int idx = ideaUrl.indexOf("://");
        if (idx >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals(JAR)) {
                s = "jar:file";
            }
            ideaUrl = s + ":/" + ideaUrl.substring(idx + 3);
        }
        return ideaUrl;
    }

    public static String fixURLforIDEA(String url) {
        int idx = url.indexOf(":/");
        if (idx >= 0 && idx + 2 < url.length() && url.charAt(idx + 2) != '/') {
            String prefix = url.substring(0, idx);
            String suffix = url.substring(idx + 2);
            url = SystemInfo.isWindows ? prefix + "://" + suffix : prefix + ":///" + suffix;
        }
        return url;
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) {
        File parent;
        File file2 = parent = strict ? file.getParentFile() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParentFile();
        }
        return false;
    }

    @Nullable
    public static Module getModuleForFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getModuleForFile must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getModuleForFile must not be null");
        }
        return ProjectRootManager.getInstance(project).getFileIndex().getModuleForFile(file);
    }

    public static String calcRelativeToProjectPath(VirtualFile file, Project project) {
        Module module;
        String projectHomeUrl;
        String url = file.getPresentableUrl();
        if (project == null) {
            return url;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            url = "..." + url.substring(projectHomeUrl.length());
        }
        if ((module = VfsUtil.getModuleForFile(project, file)) == null) {
            return url;
        }
        return new StringBuffer().append("[").append(module.getName()).append("] - ").append(url).toString();
    }

    @Nullable
    public static String getPath(VirtualFile src, VirtualFile dst, char separatorChar) {
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (src != commonAncestor) {
                while (src.getParent() != commonAncestor) {
                    buffer.append("..").append(separatorChar);
                    src = src.getParent();
                    assert (src != null);
                }
            }
            buffer.append(VfsUtil.getRelativePath(dst, commonAncestor, separatorChar));
            return buffer.toString();
        }
        return null;
    }

    @Nullable
    public static Project guessProjectForFile(VirtualFile file) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null) {
            return null;
        }
        Project[] projects = projectManager.getOpenProjects();
        if (projects.length == 1) {
            return projects[0];
        }
        for (Project project : projects) {
            if (!ProjectRootManager.getInstance(project).getFileIndex().isInContent(file)) continue;
            return project;
        }
        return projects.length == 0 ? null : projects[0];
    }

    public static boolean isValidName(String name) {
        return name.indexOf(92) < 0 && name.indexOf(47) < 0;
    }

    public static String getUrlForLibraryRoot(File libraryRoot) {
        String path = FileUtil.toSystemIndependentName(libraryRoot.getAbsolutePath());
        if (FileTypeManager.getInstance().getFileTypeByFileName(libraryRoot.getName()) == StdFileTypes.ARCHIVE) {
            return VirtualFileManager.constructUrl(JarFileSystem.getInstance().getProtocol(), path + "!/");
        }
        return VirtualFileManager.constructUrl(LocalFileSystem.getInstance().getProtocol(), path);
    }

    public static VirtualFile createChildSequent(Object requestor, VirtualFile dir, String prefix, String extension) throws IOException {
        String fileName = prefix + "." + extension;
        int i = 1;
        while (dir.findChild(fileName) != null) {
            fileName = prefix + i + "." + extension;
            ++i;
        }
        return dir.createChildData(requestor, fileName);
    }

    public static String[] filterNames(String[] names) {
        int filteredCount = 0;
        for (String string : names) {
            if (!VfsUtil.isBadName(string)) continue;
            ++filteredCount;
        }
        if (filteredCount == 0) {
            return names;
        }
        String[] result = new String[names.length - filteredCount];
        int count = 0;
        for (String string : names) {
            if (VfsUtil.isBadName(string)) continue;
            result[count++] = string;
        }
        return result;
    }

    public static boolean isBadName(String name) {
        return name == null || name.length() == 0 || "/".equals(name) || "\\".equals(name);
    }

    public static void createDirectories(String dir) throws IOException {
        final String path = FileUtil.toSystemIndependentName(dir);
        final Ref err = new Ref();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                try {
                    VfsUtil.createDirectoryIfMissing(path);
                }
                catch (IOException e) {
                    err.set(e);
                }
            }
        });
        if (!err.isNull()) {
            throw (IOException)err.get();
        }
    }

    @Nullable
    private static VirtualFile createDirectoryIfMissing(String dir) throws IOException {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir);
        if (file == null) {
            int pos = dir.lastIndexOf(47);
            if (pos < 0) {
                return null;
            }
            VirtualFile parent = VfsUtil.createDirectoryIfMissing(dir.substring(0, pos));
            if (parent == null) {
                return null;
            }
            String dirName = dir.substring(pos + 1);
            return parent.createChildDirectory(LocalFileSystem.getInstance(), dirName);
        }
        return file;
    }
}

