/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.CommonBundle;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class ReadonlyStatusHandler {
    public abstract OperationStatus ensureFilesWritable(VirtualFile ... var1);

    public static ReadonlyStatusHandler getInstance(Project project) {
        return ServiceManager.getService(project, ReadonlyStatusHandler.class);
    }

    public static class OperationStatus {
        private final VirtualFile[] myReadonlyFiles;
        private final VirtualFile[] myUpdatedFiles;

        public OperationStatus(VirtualFile[] readonlyFiles, VirtualFile[] updatedFiles) {
            this.myReadonlyFiles = readonlyFiles;
            this.myUpdatedFiles = updatedFiles;
        }

        public VirtualFile[] getReadonlyFiles() {
            return this.myReadonlyFiles;
        }

        public VirtualFile[] getUpdatedFiles() {
            return this.myUpdatedFiles;
        }

        public boolean hasUpdatedFiles() {
            return this.myUpdatedFiles.length > 0;
        }

        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                StringBuffer buf = new StringBuffer();
                if (this.myReadonlyFiles.length > 1) {
                    for (VirtualFile file : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file.getPresentableUrl());
                    }
                    return CommonBundle.message("failed.to.make.the.following.files.writable.error.message", buf.toString());
                }
                return CommonBundle.message("failed.to.make.file.writeable.error.message", this.myReadonlyFiles[0].getPresentableUrl());
            }
            return null;
        }
    }

    public static class UnsuccessfulOperation
    extends Exception {
        public UnsuccessfulOperation(String message) {
            super(message);
        }
    }
}

