/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JarFileSystem
extends NewVirtualFileSystem {
    @NonNls
    public static final String PROTOCOL = "jar";
    @NonNls
    public static final String PROTOCOL_PREFIX = "jar://";
    @NonNls
    public static final String JAR_SEPARATOR = "!/";

    public static JarFileSystem getInstance() {
        return ApplicationManager.getApplication().getComponent(JarFileSystem.class);
    }

    public abstract VirtualFile getVirtualFileForJar(VirtualFile var1);

    public abstract ZipFile getJarFile(VirtualFile var1) throws IOException;

    public abstract void setNoCopyJarForPath(String var1);

    @Nullable
    public VirtualFile getJarRootForLocalFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/JarFileSystem.getJarRootForLocalFile must not be null");
        }
        if (virtualFile.getFileType() != StdFileTypes.ARCHIVE) {
            return null;
        }
        return this.findFileByPath(virtualFile.getPath() + JAR_SEPARATOR);
    }
}

