/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    protected final List<VirtualFileListener> myFileListeners = new CopyOnWriteArrayList<VirtualFileListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVirtualFileListener(VirtualFileListener listener) {
        List<VirtualFileListener> list = this.myFileListeners;
        synchronized (list) {
            this.myFileListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVirtualFileListener(VirtualFileListener listener) {
        List<VirtualFileListener> list = this.myFileListeners;
        synchronized (list) {
            this.myFileListeners.remove(listener);
        }
    }

    protected void firePropertyChanged(Object requestor, VirtualFile file, String propertyName, Object oldValue, Object newValue) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.propertyChanged(event);
            }
        }
    }

    protected void fireContentsChanged(Object requestor, VirtualFile file, long oldModificationStamp) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getParent(), oldModificationStamp, file.getModificationStamp());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.contentsChanged(event);
            }
        }
    }

    protected void fireFileCreated(Object requestor, VirtualFile file) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.fileCreated(event);
            }
        }
    }

    protected void fireFileDeleted(Object requestor, VirtualFile file, String fileName, VirtualFile parent) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, fileName, parent);
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.fileDeleted(event);
            }
        }
    }

    protected void fireFileMoved(Object requestor, VirtualFile file, VirtualFile oldParent) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, oldParent, file.getParent());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.fileMoved(event);
            }
        }
    }

    protected void fireFileCopied(@Nullable Object requestor, @NotNull VirtualFile originalFile, @NotNull VirtualFile createdFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireFileCopied must not be null");
        }
        if (createdFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/DeprecatedVirtualFileSystem.fireFileCopied must not be null");
        }
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileCopyEvent event = new VirtualFileCopyEvent(requestor, originalFile, createdFile);
            for (VirtualFileListener listener : this.myFileListeners) {
                try {
                    listener.fileCopied(event);
                }
                catch (AbstractMethodError e) {
                    listener.fileCreated(event);
                }
            }
        }
    }

    protected void fireBeforePropertyChange(Object requestor, VirtualFile file, String propertyName, Object oldValue, Object newValue) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.beforePropertyChange(event);
            }
        }
    }

    protected void fireBeforeContentsChange(Object requestor, VirtualFile file) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.beforeContentsChange(event);
            }
        }
    }

    protected void fireBeforeFileDeletion(Object requestor, VirtualFile file) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.beforeFileDeletion(event);
            }
        }
    }

    protected void fireBeforeFileMovement(Object requestor, VirtualFile file, VirtualFile newParent) {
        this.assertWriteAccessAllowed();
        if (!this.myFileListeners.isEmpty()) {
            VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, file.getParent(), newParent);
            for (VirtualFileListener listener : this.myFileListeners) {
                listener.beforeFileMovement(event);
            }
        }
    }

    protected void assertWriteAccessAllowed() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
    }

    public boolean isReadOnly() {
        return true;
    }
}

