/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.CharsetSettings;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;

public class CharsetToolkit {
    @NonNls
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final byte[] buffer;
    private Charset defaultCharset;
    private boolean enforce8Bit = false;
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    @NonNls
    public static final String FILE_ENCODING_PROPERTY = "file.encoding";

    public CharsetToolkit(byte[] buffer) {
        this.buffer = buffer;
        this.defaultCharset = CharsetToolkit.getDefaultSystemCharset();
    }

    public CharsetToolkit(byte[] buffer, Charset defaultCharset) {
        this.buffer = buffer;
        this.setDefaultCharset(defaultCharset);
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : CharsetToolkit.getDefaultSystemCharset();
    }

    public void setEnforce8Bit(boolean enforce) {
        this.enforce8Bit = enforce;
    }

    public boolean getEnforce8Bit() {
        return this.enforce8Bit;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Charset guessEncoding(int guess_length, Charset defaultCharset) {
        Charset charset = this.guessFromBOM();
        if (charset != null) {
            return charset;
        }
        GuessedEncoding encoding = this.guessFromContent(guess_length);
        switch (encoding) {
            case SEVEN_BIT: {
                if (this.enforce8Bit) {
                    return defaultCharset;
                }
                return Charset.forName("US-ASCII");
            }
            case INVALID_UTF8: {
                return defaultCharset;
            }
            case VALID_UTF8: {
                return UTF8_CHARSET;
            }
        }
        return null;
    }

    public static String bytesToString(byte[] bytes) {
        Charset charset = new CharsetToolkit(bytes, CharsetToolkit.getIDEOptionsCharset()).guessEncoding(bytes.length);
        int bomLength = CharsetToolkit.getBOMLength(bytes, charset);
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
        return charBuffer.toString();
    }

    public GuessedEncoding guessFromContent(int guess_length) {
        boolean highOrderBit = false;
        boolean validU8Char = true;
        int length = Math.min(this.buffer.length, guess_length);
        for (int i = 0; i < length; ++i) {
            byte b5;
            byte b0 = this.buffer[i];
            byte b1 = i + 1 >= length ? (byte)0 : this.buffer[i + 1];
            byte b2 = i + 2 >= length ? (byte)0 : this.buffer[i + 2];
            byte b3 = i + 3 >= length ? (byte)0 : this.buffer[i + 3];
            byte b4 = i + 4 >= length ? (byte)0 : this.buffer[i + 4];
            byte by = b5 = i + 5 >= length ? (byte)0 : this.buffer[i + 5];
            if (b0 < 0) {
                highOrderBit = true;
                if (CharsetToolkit.isTwoBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1)) {
                        validU8Char = false;
                    } else {
                        ++i;
                    }
                } else if (CharsetToolkit.isThreeBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1) || !CharsetToolkit.isContinuationChar(b2)) {
                        validU8Char = false;
                    } else {
                        i += 2;
                    }
                } else if (CharsetToolkit.isFourBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3))) {
                        validU8Char = false;
                    } else {
                        i += 3;
                    }
                } else if (CharsetToolkit.isFiveBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4))) {
                        validU8Char = false;
                    } else {
                        i += 4;
                    }
                } else if (CharsetToolkit.isSixBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4) && CharsetToolkit.isContinuationChar(b5))) {
                        validU8Char = false;
                    } else {
                        i += 5;
                    }
                } else {
                    validU8Char = false;
                }
            }
            if (!validU8Char) break;
        }
        if (!highOrderBit) {
            return GuessedEncoding.SEVEN_BIT;
        }
        if (validU8Char) {
            return GuessedEncoding.VALID_UTF8;
        }
        return GuessedEncoding.INVALID_UTF8;
    }

    public Charset guessFromBOM() {
        if (CharsetToolkit.hasUTF8Bom(this.buffer)) {
            return UTF8_CHARSET;
        }
        if (CharsetToolkit.hasUTF16LEBom(this.buffer)) {
            return Charset.forName("UTF-16LE");
        }
        if (CharsetToolkit.hasUTF16BEBom(this.buffer)) {
            return Charset.forName("UTF-16BE");
        }
        return null;
    }

    public Charset guessEncoding(int guess_length) {
        return this.guessEncoding(guess_length, this.defaultCharset);
    }

    public static Charset guessEncoding(File f, int bufferLength) throws IOException {
        return CharsetToolkit.guessEncoding(f, bufferLength, CharsetToolkit.getIDEOptionsCharset());
    }

    public static Charset getIDEOptionsCharset() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return null;
        }
        CharsetSettings settings = CharsetSettings.getInstance();
        if (settings == null) {
            return null;
        }
        String charsetName = settings.getCharsetName();
        if ("System Default".equals(charsetName)) {
            return CharsetToolkit.getDefaultSystemCharset();
        }
        if (!Charset.isSupported(charsetName)) {
            return CharsetToolkit.getDefaultSystemCharset();
        }
        Charset charset = CharsetToolkit.forName(charsetName);
        return charset == null ? CharsetToolkit.getDefaultSystemCharset() : charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset guessEncoding(File f, int bufferLength, Charset defaultCharset) throws IOException {
        int read;
        FileInputStream fis = new FileInputStream(f);
        byte[] buffer = new byte[bufferLength];
        try {
            read = fis.read(buffer);
        }
        finally {
            fis.close();
        }
        CharsetToolkit toolkit = new CharsetToolkit(buffer);
        toolkit.setDefaultCharset(defaultCharset);
        return toolkit.guessEncoding(read);
    }

    private static boolean isContinuationChar(byte b) {
        return -128 <= b && b <= -65;
    }

    private static boolean isTwoBytesSequence(byte b) {
        return -64 <= b && b <= -33;
    }

    private static boolean isThreeBytesSequence(byte b) {
        return -32 <= b && b <= -17;
    }

    private static boolean isFourBytesSequence(byte b) {
        return -16 <= b && b <= -9;
    }

    private static boolean isFiveBytesSequence(byte b) {
        return -8 <= b && b <= -5;
    }

    private static boolean isSixBytesSequence(byte b) {
        return -4 <= b && b <= -3;
    }

    public static Charset getDefaultSystemCharset() {
        Charset charset = null;
        try {
            charset = Charset.forName(System.getProperty(FILE_ENCODING_PROPERTY));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return charset;
    }

    public static boolean hasUTF8Bom(byte[] bom) {
        return ArrayUtil.startsWith(bom, UTF8_BOM);
    }

    public static boolean hasUTF16LEBom(byte[] bom) {
        return ArrayUtil.startsWith(bom, UTF16LE_BOM);
    }

    public static boolean hasUTF16BEBom(byte[] bom) {
        return ArrayUtil.startsWith(bom, UTF16BE_BOM);
    }

    public static Charset[] getAvailableCharsets() {
        Collection<Charset> collection = Charset.availableCharsets().values();
        return collection.toArray(new Charset[collection.size()]);
    }

    public static byte[] getUtf8Bytes(String s) {
        try {
            return s.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getBOMLength(byte[] content, Charset charset) {
        if (charset != null && charset.name().contains(UTF8) && CharsetToolkit.hasUTF8Bom(content)) {
            return UTF8_BOM.length;
        }
        if (CharsetToolkit.hasUTF16LEBom(content)) {
            return UTF16LE_BOM.length;
        }
        if (CharsetToolkit.hasUTF16BEBom(content)) {
            return UTF16BE_BOM.length;
        }
        return 0;
    }

    public static Charset forName(String name) {
        Charset charset = null;
        if (name != null) {
            try {
                charset = Charset.forName(name);
            }
            catch (IllegalCharsetNameException e) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GuessedEncoding {
        SEVEN_BIT,
        VALID_UTF8,
        INVALID_UTF8;

    }
}

