/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import java.io.IOException;

public class VcsVirtualFile
extends AbstractVcsVirtualFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vcs.vfs.VcsVirtualFile");
    private byte[] myContent;
    private final VcsFileRevision myFileRevision;
    private boolean myContentLoadFailed = false;

    public VcsVirtualFile(String path, VcsFileRevision revision, VirtualFileSystem fileSystem) {
        super(path, fileSystem);
        this.myFileRevision = revision;
    }

    public VcsVirtualFile(String path, byte[] content, String revision, VirtualFileSystem fileSystem) {
        this(path, null, fileSystem);
        this.myContent = content;
        this.setRevision(revision);
    }

    public byte[] contentsToByteArray() throws IOException {
        if (this.myContentLoadFailed) {
            return new byte[0];
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        return this.myContent;
    }

    private void loadContent() throws IOException {
        if (this.myContent != null) {
            return;
        }
        final VcsFileSystem vcsFileSystem = (VcsFileSystem)this.getFileSystem();
        try {
            this.myFileRevision.loadContent();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                public void run() {
                    vcsFileSystem.fireBeforeContentsChange(this, VcsVirtualFile.this);
                }
            });
            ++this.myModificationStamp;
            this.setRevision(this.myFileRevision.getRevisionNumber().asString());
            this.myContent = this.myFileRevision.getContent();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                public void run() {
                    vcsFileSystem.fireContentsChanged(this, VcsVirtualFile.this, 0L);
                }
            });
        }
        catch (VcsException e) {
            this.myContentLoadFailed = true;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                public void run() {
                    vcsFileSystem.fireBeforeFileDeletion(this, VcsVirtualFile.this);
                }
            });
            this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
            this.setRevision("0");
            Messages.showMessageDialog(VcsBundle.message("message.text.could.not.load.virtual.file.content", this.getPresentableUrl(), e.getLocalizedMessage()), VcsBundle.message("message.title.could.not.load.content", new Object[0]), Messages.getInformationIcon());
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                public void run() {
                    vcsFileSystem.fireFileDeleted(this, VcsVirtualFile.this, VcsVirtualFile.this.getName(), VcsVirtualFile.this.getParent());
                }
            });
        }
        catch (ProcessCanceledException ex) {
            this.myContent = null;
        }
    }

    public boolean isDirectory() {
        return false;
    }

    public String getRevision() {
        if (this.myRevision == null) {
            try {
                this.loadContent();
            }
            catch (IOException e) {
                LOG.info(e);
            }
        }
        return this.myRevision;
    }
}

