/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.DeprecatedVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsVirtualFile
extends DeprecatedVirtualFile {
    protected final String myName;
    protected final String myPath;
    protected String myRevision;
    private final VirtualFile myParent;
    protected int myModificationStamp = 0;
    private final VirtualFileSystem myFileSystem;

    protected AbstractVcsVirtualFile(String path, VirtualFileSystem fileSystem) {
        this.myFileSystem = fileSystem;
        this.myPath = path;
        File file = new File(this.myPath);
        this.myName = file.getName();
        this.myParent = !this.isDirectory() ? new VcsVirtualFolder(file.getParent(), this, this.myFileSystem) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFileSystem;
        if (virtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile.getFileSystem must not return null");
        }
        return virtualFileSystem;
    }

    public String getPath() {
        return this.myPath;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile.getName must not return null");
        }
        return string;
    }

    public String getPresentableName() {
        if (this.myRevision == null) {
            return this.myName;
        }
        return this.myName + " (" + this.myRevision + ")";
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        byte[] buf = this.contentsToByteArray();
        if (buf != null) {
            return new ByteArrayInputStream(buf);
        }
        return new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new RuntimeException(VcsFileSystem.COULD_NOT_IMPLEMENT_MESSAGE);
    }

    public abstract byte[] contentsToByteArray() throws IOException;

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public long getTimeStamp() {
        return this.myModificationStamp;
    }

    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    protected void setRevision(String revision) {
        this.myRevision = revision;
    }
}

