/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGroup
implements JDOMExternalizable {
    public String myUpdateName;
    public String myStatusName;
    private final Collection<UpdatedFile> myFiles = new ArrayList<UpdatedFile>();
    public boolean mySupportsDeletion;
    public boolean myCanBeAbsent;
    public String myId;
    @NonNls
    private static final String PATH = "PATH";
    @NonNls
    private static final String VCS_ATTRIBUTE = "vcs";
    @NonNls
    private static final String REVISION_ATTRIBUTE = "revision";
    private final List<FileGroup> myChildren = new ArrayList<FileGroup>();
    @NonNls
    private static final String FILE_GROUP_ELEMENT_NAME = "FILE-GROUP";
    @NonNls
    public static final String MODIFIED_ID = "MODIFIED";
    @NonNls
    public static final String MERGED_WITH_CONFLICT_ID = "MERGED_WITH_CONFLICTS";
    @NonNls
    public static final String MERGED_ID = "MERGED";
    @NonNls
    public static final String UNKNOWN_ID = "UNKNOWN";
    @NonNls
    public static final String LOCALLY_ADDED_ID = "LOCALLY_ADDED";
    @NonNls
    public static final String LOCALLY_REMOVED_ID = "LOCALLY_REMOVED";
    @NonNls
    public static final String UPDATED_ID = "UPDATED";
    @NonNls
    public static final String REMOVED_FROM_REPOSITORY_ID = "REMOVED_FROM_REPOSITORY";
    @NonNls
    public static final String CREATED_ID = "CREATED";
    @NonNls
    public static final String RESTORED_ID = "RESTORED";
    @NonNls
    public static final String CHANGED_ON_SERVER_ID = "CHANGED_ON_SERVER";
    @NonNls
    public static final String SKIPPED_ID = "SKIPPED";

    public FileGroup(String updateName, String statusName, boolean supportsDeletion, String id, boolean canBeAbsent) {
        this.mySupportsDeletion = supportsDeletion;
        this.myId = id;
        this.myCanBeAbsent = canBeAbsent;
        this.myUpdateName = updateName;
        this.myStatusName = statusName;
    }

    public FileGroup() {
    }

    public void addChild(FileGroup child) {
        this.myChildren.add(child);
    }

    public boolean getSupportsDeletion() {
        return this.mySupportsDeletion;
    }

    public void add(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/update/FileGroup.add must not be null");
        }
        this.myFiles.add(new UpdatedFile(path));
    }

    public void add(@NotNull String path, @NotNull AbstractVcs vcs, @NotNull VcsRevisionNumber revision) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/update/FileGroup.add must not be null");
        }
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/update/FileGroup.add must not be null");
        }
        if (revision == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vcs/update/FileGroup.add must not be null");
        }
        this.myFiles.add(new UpdatedFile(path, vcs.getName(), revision.asString()));
    }

    public void remove(String path) {
        for (UpdatedFile file : this.myFiles) {
            if (!file.getPath().equals(path)) continue;
            this.myFiles.remove(file);
            break;
        }
    }

    public Collection<String> getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (UpdatedFile file : this.myFiles) {
            files.add(file.getPath());
        }
        return files;
    }

    public List<Pair<String, VcsRevisionNumber>> getFilesAndRevisions(ProjectLevelVcsManager vcsManager) {
        ArrayList<Pair<String, VcsRevisionNumber>> files = new ArrayList<Pair<String, VcsRevisionNumber>>();
        for (UpdatedFile file : this.myFiles) {
            VcsRevisionNumber number = FileGroup.getRevision(vcsManager, file);
            files.add(new Pair<String, VcsRevisionNumber>(file.getPath(), number));
        }
        return files;
    }

    public boolean isEmpty() {
        if (!this.myFiles.isEmpty()) {
            return false;
        }
        for (FileGroup child : this.myChildren) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public SimpleTextAttributes getInvalidAttributes() {
        if (this.myCanBeAbsent) {
            return new SimpleTextAttributes(0, FileStatus.DELETED.getColor());
        }
        return SimpleTextAttributes.ERROR_ATTRIBUTES;
    }

    public String getId() {
        return this.myId;
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element);
        for (UpdatedFile file : this.myFiles) {
            Element path = new Element(PATH);
            path.setText(file.getPath());
            if (file.getVcsName() != null) {
                path.setAttribute(VCS_ATTRIBUTE, file.getVcsName());
            }
            if (file.getRevision() != null) {
                path.setAttribute(REVISION_ATTRIBUTE, file.getRevision());
            }
            element.addContent(path);
        }
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
        List pathElements = element.getChildren(PATH);
        for (Object pathElement1 : pathElements) {
            Element pathElement = (Element)pathElement1;
            String path = pathElement.getText();
            String vcsName = pathElement.getAttributeValue(VCS_ATTRIBUTE);
            String revision = pathElement.getAttributeValue(REVISION_ATTRIBUTE);
            this.myFiles.add(new UpdatedFile(path, vcsName, revision));
        }
    }

    public List<FileGroup> getChildren() {
        return this.myChildren;
    }

    public static void writeGroupsToElement(List<FileGroup> groups, Element element) throws WriteExternalException {
        for (FileGroup fileGroup : groups) {
            Element groupElement = new Element(FILE_GROUP_ELEMENT_NAME);
            element.addContent(groupElement);
            fileGroup.writeExternal(groupElement);
            FileGroup.writeGroupsToElement(fileGroup.getChildren(), groupElement);
        }
    }

    public static void readGroupsFromElement(List<FileGroup> groups, Element element) throws InvalidDataException {
        List groupElements = element.getChildren();
        for (Object groupElement1 : groupElements) {
            Element groupElement = (Element)groupElement1;
            FileGroup fileGroup = new FileGroup();
            fileGroup.readExternal(groupElement);
            groups.add(fileGroup);
            FileGroup.readGroupsFromElement(fileGroup.myChildren, groupElement);
        }
    }

    public String getStatusName() {
        return this.myStatusName;
    }

    public String getUpdateName() {
        return this.myUpdateName;
    }

    public String toString() {
        return this.myId + " " + this.myFiles.size() + " items";
    }

    @Nullable
    public VcsRevisionNumber getRevision(ProjectLevelVcsManager vcsManager, String path) {
        for (UpdatedFile file : this.myFiles) {
            if (!file.getPath().equals(path)) continue;
            return FileGroup.getRevision(vcsManager, file);
        }
        return null;
    }

    @Nullable
    private static VcsRevisionNumber getRevision(ProjectLevelVcsManager vcsManager, UpdatedFile file) {
        AbstractVcs vcs;
        String vcsName = file.getVcsName();
        String revision = file.getRevision();
        if (vcsName != null && revision != null && (vcs = vcsManager.findVcsByName(vcsName)) != null) {
            return vcs.parseRevisionNumber(revision);
        }
        return null;
    }

    public void setRevisions(String path, AbstractVcs vcs, VcsRevisionNumber revision) {
        for (UpdatedFile file : this.myFiles) {
            if (!file.getPath().startsWith(path)) continue;
            file.setVcsName(vcs.getName());
            file.setRevision(revision.asString());
        }
        for (FileGroup group : this.myChildren) {
            group.setRevisions(path, vcs, revision);
        }
    }

    private static class UpdatedFile {
        private final String myPath;
        private String myVcsName;
        private String myRevision;

        public UpdatedFile(String path) {
            this.myPath = path;
        }

        public UpdatedFile(String path, String vcsName, String revision) {
            this.myPath = path;
            this.myVcsName = vcsName;
            this.myRevision = revision;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getVcsName() {
            return this.myVcsName;
        }

        public void setVcsName(String vcsName) {
            this.myVcsName = vcsName;
        }

        public String getRevision() {
            return this.myRevision;
        }

        public void setRevision(String revision) {
            this.myRevision = revision;
        }
    }
}

