/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VcsHistorySession {
    private final List<VcsFileRevision> myRevisions;
    private VcsRevisionNumber myCachedRevisionNumber;

    public VcsHistorySession(List<VcsFileRevision> revisions) {
        this.myRevisions = revisions;
        this.myCachedRevisionNumber = this.calcCurrentRevisionNumber();
    }

    protected VcsHistorySession(List<VcsFileRevision> revisions, VcsRevisionNumber currentRevisionNumber) {
        this.myRevisions = revisions;
        this.myCachedRevisionNumber = currentRevisionNumber;
    }

    public List<VcsFileRevision> getRevisionList() {
        return this.myRevisions;
    }

    @Nullable
    protected abstract VcsRevisionNumber calcCurrentRevisionNumber();

    public final synchronized VcsRevisionNumber getCurrentRevisionNumber() {
        return this.myCachedRevisionNumber;
    }

    public boolean isCurrentRevision(VcsRevisionNumber rev) {
        VcsRevisionNumber revNumber = this.getCurrentRevisionNumber();
        return revNumber != null && revNumber.compareTo(rev) == 0;
    }

    public synchronized boolean refresh() {
        VcsRevisionNumber oldValue = this.myCachedRevisionNumber;
        this.myCachedRevisionNumber = this.calcCurrentRevisionNumber();
        return !Comparing.equal(oldValue, this.myCachedRevisionNumber);
    }

    public boolean allowAsyncRefresh() {
        return false;
    }

    public boolean isContentAvailable(VcsFileRevision revision) {
        return true;
    }
}

