/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Date;

public class CurrentRevision
implements VcsFileRevision {
    private final VirtualFile myFile;
    public static final String CURRENT = VcsBundle.message("vcs.revision.name.current", new Object[0]);
    private final VcsRevisionNumber myRevisionNumber;

    public CurrentRevision(VirtualFile file, VcsRevisionNumber revision) {
        this.myFile = file;
        this.myRevisionNumber = revision;
    }

    public String getCommitMessage() {
        return "[" + CURRENT + "]";
    }

    public void loadContent() {
    }

    public Date getRevisionDate() {
        return new Date(this.myFile.getTimeStamp());
    }

    public byte[] getContent() {
        try {
            Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
            if (document != null) {
                return document.getText().getBytes(this.myFile.getCharset().name());
            }
            return this.myFile.contentsToByteArray();
        }
        catch (IOException e) {
            Messages.showMessageDialog(e.getLocalizedMessage(), VcsBundle.message("message.text.could.not.load.file.content", new Object[0]), Messages.getErrorIcon());
            return null;
        }
    }

    public String getAuthor() {
        return "";
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public String getBranchName() {
        return null;
    }
}

