/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeAnalysisBeforeCheckinHandler
extends CheckinHandler {
    private final Project myProject;
    private final CheckinProjectPanel myCheckinPanel;

    public CodeAnalysisBeforeCheckinHandler(Project project, CheckinProjectPanel panel) {
        this.myProject = project;
        this.myCheckinPanel = panel;
    }

    @Override
    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        final JCheckBox checkBox = new JCheckBox(VcsBundle.message("before.checkin.standard.options.check.smells", new Object[0]));
        return new RefreshableOnComponent(){

            public JComponent getComponent() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add(checkBox);
                return panel;
            }

            public void refresh() {
            }

            public void saveState() {
                ((CodeAnalysisBeforeCheckinHandler)CodeAnalysisBeforeCheckinHandler.this).getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT = checkBox.isSelected();
            }

            public void restoreState() {
                checkBox.setSelected(((CodeAnalysisBeforeCheckinHandler)CodeAnalysisBeforeCheckinHandler.this).getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    private VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance(this.myProject);
    }

    private CheckinHandler.ReturnResult processFoundCodeSmells(List<CodeSmellInfo> codeSmells, @Nullable CommitExecutor executor) {
        int answer;
        String commitButtonText;
        int errorCount = CodeAnalysisBeforeCheckinHandler.collectErrors(codeSmells);
        int warningCount = codeSmells.size() - errorCount;
        String string = commitButtonText = executor != null ? executor.getActionText() : this.myCheckinPanel.getCommitActionName();
        if (commitButtonText.endsWith("...")) {
            commitButtonText = commitButtonText.substring(0, commitButtonText.length() - 3);
        }
        if ((answer = Messages.showDialog(VcsBundle.message("before.commit.files.contain.code.smells.edit.them.confirm.text", errorCount, warningCount), VcsBundle.message("code.smells.error.messages.tab.name", new Object[0]), new String[]{VcsBundle.message("code.smells.review.button", new Object[0]), commitButtonText, CommonBundle.getCancelButtonText()}, 0, UIUtil.getWarningIcon())) == 0) {
            AbstractVcsHelper.getInstance(this.myProject).showCodeSmellErrors(codeSmells);
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }
        if (answer == 2 || answer == -1) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    private static int collectErrors(List<CodeSmellInfo> codeSmells) {
        int result = 0;
        for (CodeSmellInfo codeSmellInfo : codeSmells) {
            if (codeSmellInfo.getSeverity() != HighlightSeverity.ERROR) continue;
            ++result;
        }
        return result;
    }

    @Override
    public CheckinHandler.ReturnResult beforeCheckin(CommitExecutor executor) {
        if (this.getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT) {
            try {
                List<CodeSmellInfo> codeSmells = AbstractVcsHelper.getInstance(this.myProject).findCodeSmells(new ArrayList<VirtualFile>(this.myCheckinPanel.getVirtualFiles()));
                if (!codeSmells.isEmpty()) {
                    return this.processFoundCodeSmells(codeSmells, executor);
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
            catch (ProcessCanceledException e) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }
}

