/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeListManager {
    public static ChangeListManager getInstance(Project project) {
        return project.getComponent(ChangeListManager.class);
    }

    public abstract void scheduleUpdate();

    public abstract void scheduleUpdate(boolean var1);

    public abstract boolean ensureUpToDate(boolean var1);

    @NotNull
    public abstract List<LocalChangeList> getChangeLists();

    public abstract List<File> getAffectedPaths();

    @NotNull
    public abstract List<VirtualFile> getAffectedFiles();

    public abstract boolean isFileAffected(VirtualFile var1);

    @Nullable
    public abstract LocalChangeList findChangeList(String var1);

    public abstract LocalChangeList addChangeList(@NotNull String var1, String var2);

    public abstract void setDefaultChangeList(@NotNull LocalChangeList var1);

    public abstract LocalChangeList getDefaultChangeList();

    public abstract LocalChangeList getChangeList(Change var1);

    @Nullable
    public abstract Change getChange(VirtualFile var1);

    @Nullable
    public abstract Change getChange(FilePath var1);

    public abstract boolean isUnversioned(VirtualFile var1);

    @NotNull
    public abstract FileStatus getStatus(VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(FilePath var1);

    public abstract void removeChangeList(LocalChangeList var1);

    public abstract void moveChangesTo(LocalChangeList var1, Change[] var2);

    public abstract void addChangeListListener(ChangeListListener var1);

    public abstract void removeChangeListListener(ChangeListListener var1);

    public abstract void registerCommitExecutor(CommitExecutor var1);

    public abstract void commitChanges(LocalChangeList var1, List<Change> var2);

    public abstract void commitChangesSynchronously(LocalChangeList var1, List<Change> var2);

    public abstract boolean commitChangesSynchronouslyWithResult(LocalChangeList var1, List<Change> var2);

    public abstract void reopenFiles(List<FilePath> var1);

    public abstract List<CommitExecutor> getRegisteredExecutors();

    public abstract void addFilesToIgnore(IgnoredFileBean ... var1);

    public abstract void setFilesToIgnore(IgnoredFileBean ... var1);

    public abstract IgnoredFileBean[] getFilesToIgnore();

    public abstract boolean isIgnoredFile(@NotNull VirtualFile var1);

    @Nullable
    public abstract String getSwitchedBranch(VirtualFile var1);
}

