/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Change {
    private final ContentRevision myBeforeRevision;
    private final ContentRevision myAfterRevision;
    private final FileStatus myFileStatus;
    private String myMoveRelativePath;
    private boolean myRenamed;
    private boolean myMoved;
    private boolean myRenameOrMoveCached = false;

    public Change(ContentRevision beforeRevision, ContentRevision afterRevision) {
        this(beforeRevision, afterRevision, Change.convertStatus(beforeRevision, afterRevision));
    }

    public Change(ContentRevision beforeRevision, ContentRevision afterRevision, FileStatus fileStatus) {
        assert (beforeRevision != null || afterRevision != null);
        this.myBeforeRevision = beforeRevision;
        this.myAfterRevision = afterRevision;
        this.myFileStatus = fileStatus;
    }

    private static FileStatus convertStatus(ContentRevision beforeRevision, ContentRevision afterRevision) {
        if (beforeRevision == null) {
            return FileStatus.ADDED;
        }
        if (afterRevision == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    public Type getType() {
        if (this.myBeforeRevision == null) {
            return Type.NEW;
        }
        if (this.myAfterRevision == null) {
            return Type.DELETED;
        }
        if (!Comparing.equal(this.myBeforeRevision.getFile(), this.myAfterRevision.getFile())) {
            return Type.MOVED;
        }
        return Type.MODIFICATION;
    }

    @Nullable
    public ContentRevision getBeforeRevision() {
        return this.myBeforeRevision;
    }

    @Nullable
    public ContentRevision getAfterRevision() {
        return this.myAfterRevision;
    }

    public FileStatus getFileStatus() {
        return this.myFileStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Change otherChange = (Change)o;
        ContentRevision br1 = this.getBeforeRevision();
        ContentRevision br2 = otherChange.getBeforeRevision();
        ContentRevision ar1 = this.getAfterRevision();
        ContentRevision ar2 = otherChange.getAfterRevision();
        FilePath fbr1 = br1 != null ? br1.getFile() : null;
        FilePath fbr2 = br2 != null ? br2.getFile() : null;
        FilePath far1 = ar1 != null ? ar1.getFile() : null;
        FilePath far2 = ar2 != null ? ar2.getFile() : null;
        return Comparing.equal(fbr1, fbr2) && Comparing.equal(far1, far2);
    }

    public int hashCode() {
        return Change.revisionHashCode(this.getBeforeRevision()) * 27 + Change.revisionHashCode(this.getAfterRevision());
    }

    private static int revisionHashCode(ContentRevision rev) {
        if (rev == null) {
            return 0;
        }
        return rev.getFile().hashCode();
    }

    public boolean affectsFile(File ioFile) {
        if (this.myBeforeRevision != null && this.myBeforeRevision.getFile().getIOFile().equals(ioFile)) {
            return true;
        }
        return this.myAfterRevision != null && this.myAfterRevision.getFile().getIOFile().equals(ioFile);
    }

    public boolean isRenamed() {
        this.cacheRenameOrMove(null);
        return this.myRenamed;
    }

    public boolean isMoved() {
        this.cacheRenameOrMove(null);
        return this.myMoved;
    }

    public String getMoveRelativePath(Project project) {
        this.cacheRenameOrMove(project);
        return this.myMoveRelativePath;
    }

    private void cacheRenameOrMove(Project project) {
        if (!this.myRenameOrMoveCached) {
            this.myRenameOrMoveCached = true;
            if (this.myBeforeRevision != null && this.myAfterRevision != null && !this.myBeforeRevision.getFile().equals(this.myAfterRevision.getFile())) {
                if (this.myBeforeRevision.getFile().getParentPath().equals(this.myAfterRevision.getFile().getParentPath())) {
                    this.myRenamed = true;
                } else {
                    this.myMoved = true;
                }
            }
        }
        if (this.myMoved && this.myMoveRelativePath == null && project != null) {
            Module newModule;
            Module oldModule;
            VirtualFile oldFile = this.myBeforeRevision.getFile().getParentPath().getVirtualFile();
            VirtualFile newFile = this.myAfterRevision.getFile().getParentPath().getVirtualFile();
            if (oldFile != null && newFile != null && (oldModule = VfsUtil.getModuleForFile(project, oldFile)) != (newModule = VfsUtil.getModuleForFile(project, newFile))) {
                this.myMoveRelativePath = ProjectLevelVcsManager.getInstance(project).getPresentableRelativePathFor(oldFile);
            }
            if (this.myMoveRelativePath == null) {
                this.myMoveRelativePath = FileUtil.getRelativePath(this.myAfterRevision.getFile().getIOFile(), this.myBeforeRevision.getFile().getIOFile());
            }
        }
    }

    @NonNls
    public String toString() {
        return "Change:" + this.myBeforeRevision + " -> " + this.myAfterRevision;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        MODIFICATION,
        NEW,
        DELETED,
        MOVED;

    }
}

