/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JList;

public class VcsRevisionListCellRenderer
extends ColoredListCellRenderer {
    public static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(3, 3);

    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        this.append(this.getRevisionString((VcsFileRevision)value), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
    }

    private String getRevisionString(VcsFileRevision revision) {
        StringBuffer result = new StringBuffer();
        result.append(revision.getRevisionNumber().asString());
        String branchName = revision.getBranchName();
        if (branchName != null && branchName.length() > 0) {
            result.append("(");
            result.append(branchName);
            result.append(")");
        }
        result.append(" ");
        result.append(DATE_FORMAT.format(revision.getRevisionDate()));
        result.append(" ");
        result.append(revision.getAuthor());
        return result.toString();
    }
}

