/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShowMessageHistoryAction
extends AnAction {
    public ShowMessageHistoryAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        CheckinProjectPanel panel = (CheckinProjectPanel)e.getDataContext().getData("Panel");
        if (panel == null) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setVisible(true);
            ArrayList<String> recentMessages = VcsConfiguration.getInstance(panel.getProject()).getRecentMessages();
            e.getPresentation().setEnabled(!recentMessages.isEmpty());
        }
    }

    public void actionPerformed(AnActionEvent e) {
        CheckinProjectPanel panel = (CheckinProjectPanel)e.getDataContext().getData("Panel");
        if (panel != null) {
            Project project = panel.getProject();
            VcsConfiguration configuration = VcsConfiguration.getInstance(project);
            final ArrayList<String> recentMessages = configuration.getRecentMessages();
            Collections.reverse(recentMessages);
            if (!recentMessages.isEmpty()) {
                int selectedIndex;
                ContentChooser<String> contentChooser = new ContentChooser<String>(project, VcsBundle.message("dialog.title.choose.commit.message.from.history", new Object[0]), false){

                    @Override
                    protected void removeContentAt(String content) {
                    }

                    @Override
                    protected String getStringRepresentationFor(String content) {
                        return content;
                    }

                    @Override
                    protected List<String> getContents() {
                        return recentMessages;
                    }
                };
                contentChooser.show();
                if (contentChooser.isOK() && (selectedIndex = contentChooser.getSelectedIndex()) >= 0) {
                    panel.setCommitMessage((String)contentChooser.getAllContents().get(selectedIndex));
                }
            }
        }
    }
}

