/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.peer.PeerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VcsVFSListener {
    protected final Project myProject;
    private final AbstractVcs myVcs;
    private final ChangeListManager myChangeListManager;
    private final MyVirtualFileAdapter myVFSListener;
    private final MyCommandAdapter myCommandListener;
    private final VcsShowConfirmationOption myAddOption;
    private final VcsShowConfirmationOption myRemoveOption;
    private final List<VirtualFile> myAddedFiles = new ArrayList<VirtualFile>();
    private final Map<VirtualFile, VirtualFile> myCopyFromMap = new HashMap<VirtualFile, VirtualFile>();
    private final List<FilePath> myDeletedFiles = new ArrayList<FilePath>();
    private final List<FilePath> myDeletedWithoutConfirmFiles = new ArrayList<FilePath>();
    private final List<MovedFileInfo> myMovedFiles = new ArrayList<MovedFileInfo>();

    protected VcsVFSListener(Project project, AbstractVcs vcs) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myChangeListManager = ChangeListManager.getInstance(project);
        this.myVFSListener = new MyVirtualFileAdapter();
        this.myCommandListener = new MyCommandAdapter();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(project);
        this.myAddOption = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
        this.myRemoveOption = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, vcs);
        VirtualFileManager.getInstance().addVirtualFileListener(this.myVFSListener);
        CommandProcessor.getInstance().addCommandListener(this.myCommandListener);
    }

    public void dispose() {
        VirtualFileManager.getInstance().removeVirtualFileListener(this.myVFSListener);
        CommandProcessor.getInstance().removeCommandListener(this.myCommandListener);
    }

    protected boolean isEventIgnored(VirtualFileEvent event) {
        if (event.isFromRefresh()) {
            return true;
        }
        return ProjectLevelVcsManager.getInstance(this.myProject).getVcsFor(event.getFile()) != this.myVcs;
    }

    protected void executeAdd() {
        ArrayList<VirtualFile> addedFiles = new ArrayList<VirtualFile>(this.myAddedFiles);
        HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(this.myCopyFromMap);
        this.myAddedFiles.clear();
        this.myCopyFromMap.clear();
        if (this.myAddOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        if (this.myAddOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.performAdding(addedFiles, copyFromMap);
        } else {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance(this.myProject);
            Collection<VirtualFile> filesToProcess = helper.selectFilesToProcess(addedFiles, this.getAddTitle(), null, this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate(), this.myAddOption);
            if (filesToProcess != null) {
                this.performAdding(new ArrayList<VirtualFile>(filesToProcess), copyFromMap);
            }
        }
    }

    private void addFileToDelete(VirtualFile file) {
        if (file.isDirectory() && !this.isDirectoryVersioningSupported()) {
            VirtualFile[] children = file.getChildren();
            if (children != null) {
                for (VirtualFile child : children) {
                    this.addFileToDelete(child);
                }
            }
        } else {
            VcsDeleteType type = this.needConfirmDeletion(file);
            if (type == VcsDeleteType.CONFIRM) {
                this.myDeletedFiles.add(PeerFactory.getInstance().getVcsContextFactory().createFilePathOn(file));
            } else if (type == VcsDeleteType.SILENT) {
                this.myDeletedWithoutConfirmFiles.add(PeerFactory.getInstance().getVcsContextFactory().createFilePathOn(file));
            }
        }
    }

    private void executeDelete() {
        ArrayList<FilePath> filesToDelete = new ArrayList<FilePath>(this.myDeletedWithoutConfirmFiles);
        ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.myDeletedFiles);
        this.myDeletedWithoutConfirmFiles.clear();
        this.myDeletedFiles.clear();
        if (this.myRemoveOption.getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            if (this.myRemoveOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || deletedFiles.isEmpty()) {
                filesToDelete.addAll(deletedFiles);
            } else {
                AbstractVcsHelper helper = AbstractVcsHelper.getInstance(this.myProject);
                Collection<FilePath> filePaths = helper.selectFilePathsToProcess(deletedFiles, this.getDeleteTitle(), null, this.getSingleFileDeleteTitle(), this.getSingleFileDeletePromptTemplate(), this.myRemoveOption);
                if (filePaths != null) {
                    filesToDelete.addAll(filePaths);
                }
            }
        }
        this.performDeletion(filesToDelete);
    }

    private void addFileToMove(VirtualFile file, String newParentPath, String newName) {
        if (file.isDirectory() && !this.isDirectoryVersioningSupported()) {
            VirtualFile[] children = file.getChildren();
            if (children != null) {
                for (VirtualFile child : children) {
                    this.addFileToMove(child, newParentPath + "/" + newName, child.getName());
                }
            }
        } else {
            this.processMovedFile(file, newParentPath, newName);
        }
    }

    protected void processMovedFile(VirtualFile file, String newParentPath, String newName) {
        if (FileStatusManager.getInstance(this.myProject).getStatus(file) != FileStatus.UNKNOWN) {
            String newPath = newParentPath + "/" + newName;
            boolean foundExistingInfo = false;
            for (MovedFileInfo info : this.myMovedFiles) {
                if (info.myFile != file) continue;
                info.myNewPath = newPath;
                foundExistingInfo = true;
                break;
            }
            if (!foundExistingInfo) {
                this.myMovedFiles.add(new MovedFileInfo(file, newPath));
            }
        }
    }

    private void executeMoveRename() {
        ArrayList<MovedFileInfo> movedFiles = new ArrayList<MovedFileInfo>(this.myMovedFiles);
        this.myMovedFiles.clear();
        this.performMoveRename(movedFiles);
    }

    protected VcsDeleteType needConfirmDeletion(VirtualFile file) {
        return VcsDeleteType.CONFIRM;
    }

    protected abstract String getAddTitle();

    protected abstract String getSingleFileAddTitle();

    protected abstract String getSingleFileAddPromptTemplate();

    protected abstract void performAdding(Collection<VirtualFile> var1, Map<VirtualFile, VirtualFile> var2);

    protected abstract String getDeleteTitle();

    protected abstract String getSingleFileDeleteTitle();

    protected abstract String getSingleFileDeletePromptTemplate();

    protected abstract void performDeletion(List<FilePath> var1);

    protected abstract void performMoveRename(List<MovedFileInfo> var1);

    protected abstract boolean isDirectoryVersioningSupported();

    private class MyCommandAdapter
    extends CommandAdapter {
        private int myCommandLevel;

        private MyCommandAdapter() {
        }

        public void commandStarted(CommandEvent event) {
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            ++this.myCommandLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandFinished(CommandEvent event) {
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            --this.myCommandLevel;
            if (!(this.myCommandLevel != 0 || VcsVFSListener.this.myAddedFiles.isEmpty() && VcsVFSListener.this.myDeletedFiles.isEmpty() && VcsVFSListener.this.myDeletedWithoutConfirmFiles.isEmpty() && VcsVFSListener.this.myMovedFiles.isEmpty())) {
                ++this.myCommandLevel;
                try {
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                finally {
                    --this.myCommandLevel;
                }
                if (!VcsVFSListener.this.myAddedFiles.isEmpty()) {
                    VcsVFSListener.this.executeAdd();
                }
                if (!VcsVFSListener.this.myDeletedFiles.isEmpty() || !VcsVFSListener.this.myDeletedWithoutConfirmFiles.isEmpty()) {
                    VcsVFSListener.this.executeDelete();
                }
                if (!VcsVFSListener.this.myMovedFiles.isEmpty()) {
                    VcsVFSListener.this.executeMoveRename();
                }
            }
        }
    }

    private class MyVirtualFileAdapter
    extends VirtualFileAdapter {
        private MyVirtualFileAdapter() {
        }

        public void fileCreated(VirtualFileEvent event) {
            if (!(VcsVFSListener.this.isEventIgnored(event) || VcsVFSListener.this.myChangeListManager.isIgnoredFile(event.getFile()) || !VcsVFSListener.this.isDirectoryVersioningSupported() && event.getFile().isDirectory())) {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        public void fileCopied(VirtualFileCopyEvent event) {
            if (VcsVFSListener.this.isEventIgnored(event) || VcsVFSListener.this.myChangeListManager.isIgnoredFile(event.getFile())) {
                return;
            }
            AbstractVcs oldVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getOriginalFile());
            if (oldVcs == VcsVFSListener.this.myVcs) {
                VirtualFile parent = event.getFile().getParent();
                if (parent != null) {
                    VcsVFSListener.this.myAddedFiles.add(event.getFile());
                    VcsVFSListener.this.myCopyFromMap.put(event.getFile(), event.getOriginalFile());
                }
            } else {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            if (!VcsVFSListener.this.isEventIgnored(event)) {
                VcsVFSListener.this.addFileToDelete(event.getFile());
            }
        }

        public void beforeFileMovement(VirtualFileMoveEvent event) {
            if (VcsVFSListener.this.isEventIgnored(event)) {
                return;
            }
            VirtualFile file = event.getFile();
            AbstractVcs newVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getNewParent());
            if (newVcs == VcsVFSListener.this.myVcs) {
                VcsVFSListener.this.addFileToMove(file, event.getNewParent().getPath(), file.getName());
            } else {
                VcsVFSListener.this.addFileToDelete(event.getFile());
            }
        }

        public void fileMoved(VirtualFileMoveEvent event) {
            if (VcsVFSListener.this.isEventIgnored(event)) {
                return;
            }
            AbstractVcs oldVcs = ProjectLevelVcsManager.getInstance(VcsVFSListener.this.myProject).getVcsFor(event.getOldParent());
            if (oldVcs != VcsVFSListener.this.myVcs) {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        public void beforePropertyChange(VirtualFilePropertyEvent event) {
            VirtualFile file;
            VirtualFile parent;
            if (!VcsVFSListener.this.isEventIgnored(event) && event.getPropertyName().equalsIgnoreCase("name") && (parent = (file = event.getFile()).getParent()) != null) {
                VcsVFSListener.this.addFileToMove(file, parent.getPath(), (String)event.getNewValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum VcsDeleteType {
        SILENT,
        CONFIRM,
        IGNORE;

    }

    protected static class MovedFileInfo {
        public final String myOldPath;
        public String myNewPath;
        private final VirtualFile myFile;

        public MovedFileInfo(VirtualFile file, String newPath) {
            this.myOldPath = file.getPath();
            this.myNewPath = newPath;
            this.myFile = file;
        }
    }
}

