/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectLevelVcsManager {
    @NonNls
    public static final String FILE_VIEW_TOOL_WINDOW_ID = "File View";

    public static ProjectLevelVcsManager getInstance(Project project) {
        return project.getComponent(ProjectLevelVcsManager.class);
    }

    public abstract AbstractVcs[] getAllVcss();

    public abstract AbstractVcs findVcsByName(@NonNls String var1);

    public abstract boolean checkAllFilesAreUnder(AbstractVcs var1, VirtualFile[] var2);

    @Nullable
    public abstract AbstractVcs getVcsFor(VirtualFile var1);

    @Nullable
    public abstract AbstractVcs getVcsFor(FilePath var1);

    @Nullable
    public abstract VirtualFile getVcsRootFor(VirtualFile var1);

    @Nullable
    public abstract VirtualFile getVcsRootFor(FilePath var1);

    public abstract boolean checkVcsIsActive(AbstractVcs var1);

    public abstract boolean checkVcsIsActive(@NonNls String var1);

    public abstract String getPresentableRelativePathFor(VirtualFile var1);

    public abstract DataProvider createVirtualAndPsiFileDataProvider(VirtualFile[] var1, VirtualFile var2);

    public abstract AbstractVcs[] getAllActiveVcss();

    public abstract void addMessageToConsoleWindow(String var1, TextAttributes var2);

    @NotNull
    public abstract VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption var1, @NotNull AbstractVcs var2);

    @NotNull
    public abstract VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation var1, @NotNull AbstractVcs var2);

    @NotNull
    public abstract VcsShowSettingOption getOrCreateCustomOption(@NotNull String var1, @NotNull AbstractVcs var2);

    public abstract void showProjectOperationInfo(UpdatedFiles var1, String var2);

    public abstract List<CheckinHandlerFactory> getRegisteredCheckinHandlerFactories();

    public abstract void registerCheckinHandlerFactory(CheckinHandlerFactory var1);

    public abstract void unregisterCheckinHandlerFactory(CheckinHandlerFactory var1);

    public abstract void addVcsListener(VcsListener var1);

    public abstract void removeVcsListener(VcsListener var1);

    public abstract void startBackgroundVcsOperation();

    public abstract void stopBackgroundVcsOperation();

    public abstract boolean isBackgroundVcsOperationRunning();

    public abstract VirtualFile[] getRootsUnderVcs(AbstractVcs var1);

    public abstract VirtualFile[] getAllVersionedRoots();

    public abstract VcsRoot[] getAllVcsRoots();

    public abstract void updateActiveVcss();

    public abstract List<VcsDirectoryMapping> getDirectoryMappings();

    public abstract List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs var1);

    @Nullable
    public abstract VcsDirectoryMapping getDirectoryMappingFor(FilePath var1);

    public abstract void setDirectoryMapping(String var1, String var2);

    public abstract void setDirectoryMappings(List<VcsDirectoryMapping> var1);

    public abstract void iterateVcsRoot(VirtualFile var1, Processor<FilePath> var2);
}

