/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.text.DateFormat;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeListColumn<T extends ChangeList> {
    public static ChangeListColumn<CommittedChangeList> DATE = new ChangeListColumn<CommittedChangeList>(){

        @Override
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.date", new Object[0]);
        }

        @Override
        public Object getValue(CommittedChangeList changeList) {
            return DateFormat.getDateTimeInstance(2, 2).format(changeList.getCommitDate());
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return o1.getCommitDate().compareTo(o2.getCommitDate());
                }
            };
        }
    };
    public static ChangeListColumn<CommittedChangeList> NAME = new ChangeListColumn<CommittedChangeList>(){

        @Override
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.committer", new Object[0]);
        }

        @Override
        public Object getValue(CommittedChangeList changeList) {
            return changeList.getCommitterName();
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return Comparing.compare((String)this.getValue(o1), (String)this.getValue(o2));
                }
            };
        }
    };
    public static ChangeListColumn<CommittedChangeList> NUMBER = new ChangeListNumberColumn(VcsBundle.message("column.name.revision.list.number", new Object[0]));
    public static ChangeListColumn<CommittedChangeList> DESCRIPTION = new ChangeListColumn<CommittedChangeList>(){

        @Override
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.description", new Object[0]);
        }

        @Override
        public Object getValue(CommittedChangeList changeList) {
            return changeList.getName();
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
        }
    };

    public abstract String getTitle();

    public abstract Object getValue(T var1);

    @Nullable
    public Comparator<T> getComparator() {
        return null;
    }

    public static boolean isCustom(ChangeListColumn column) {
        return column != DATE && column != DESCRIPTION && column != NAME && !(column instanceof ChangeListNumberColumn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeListNumberColumn
    extends ChangeListColumn<CommittedChangeList> {
        private String myTitle;

        public ChangeListNumberColumn(String title) {
            this.myTitle = title;
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        public Object getValue(CommittedChangeList changeList) {
            return changeList.getNumber();
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return (int)(o1.getNumber() - o2.getNumber());
                }
            };
        }
    }
}

