/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVcsHelper {
    public static AbstractVcsHelper getInstance(Project project) {
        return ServiceManager.getService(project, AbstractVcsHelper.class);
    }

    public abstract void showErrors(List<VcsException> var1, @NotNull String var2);

    public abstract LocalHistoryAction startLocalHistoryAction(String var1);

    public abstract List<VcsException> runTransactionRunnable(AbstractVcs var1, TransactionRunnable var2, Object var3);

    public abstract void optimizeImportsAndReformatCode(Collection<VirtualFile> var1, VcsConfiguration var2, Runnable var3, boolean var4);

    public void showError(VcsException e, String s) {
        this.showErrors(Arrays.asList(e), s);
    }

    public abstract void showAnnotation(FileAnnotation var1, VirtualFile var2);

    public abstract void showDifferences(VcsFileRevision var1, VcsFileRevision var2, File var3);

    public abstract void showChangesBrowser(List<CommittedChangeList> var1);

    public abstract void showChangesBrowser(List<CommittedChangeList> var1, @Nls String var2);

    public abstract void showChangesBrowser(CommittedChangeList var1, @Nls String var2);

    public abstract void showChangesBrowser(CommittedChangesProvider var1, RepositoryLocation var2, @Nls String var3, @Nullable Component var4);

    public abstract void showChangesBrowser(@Nullable Component var1, Collection<Change> var2, @Nls String var3);

    @Nullable
    public abstract <T extends CommittedChangeList, U extends ChangeBrowserSettings> T chooseCommittedChangeList(CommittedChangesProvider<T, U> var1, RepositoryLocation var2);

    public abstract void openCommittedChangesTab(CommittedChangesProvider var1, VirtualFile var2, ChangeBrowserSettings var3, int var4, String var5);

    public abstract void openCommittedChangesTab(CommittedChangesProvider var1, RepositoryLocation var2, ChangeBrowserSettings var3, int var4, String var5);

    @NotNull
    public abstract List<VirtualFile> showMergeDialog(List<VirtualFile> var1, MergeProvider var2);

    public abstract List<CodeSmellInfo> findCodeSmells(List<VirtualFile> var1) throws ProcessCanceledException;

    public abstract void showCodeSmellErrors(List<CodeSmellInfo> var1);

    public abstract void showFileHistory(VcsHistoryProvider var1, FilePath var2);

    public abstract void showFileHistory(VcsHistoryProvider var1, AnnotationProvider var2, FilePath var3);

    public abstract void showRollbackChangesDialog(List<Change> var1);

    @Nullable
    public abstract Collection<VirtualFile> selectFilesToProcess(List<VirtualFile> var1, String var2, @Nullable String var3, String var4, String var5, VcsShowConfirmationOption var6);

    @Nullable
    public abstract Collection<FilePath> selectFilePathsToProcess(List<FilePath> var1, String var2, @Nullable String var3, String var4, String var5, VcsShowConfirmationOption var6);
}

