/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.localVcs.LocalVcsItemsLocker;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcs {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vcs.AbstractVcs");
    protected final Project myProject;
    private boolean myIsStarted = false;
    private VcsShowSettingOption myUpdateOption;
    private VcsShowSettingOption myStatusOption;

    public AbstractVcs(Project project) {
        this.myProject = project;
    }

    @NonNls
    public abstract String getName();

    @NonNls
    public abstract String getDisplayName();

    public abstract Configurable getConfigurable();

    @Nullable
    public TransactionProvider getTransactionProvider() {
        return null;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return null;
    }

    public final VcsConfiguration getConfiguration() {
        return VcsConfiguration.getInstance(this.myProject);
    }

    @Nullable
    public EditFileProvider getEditFileProvider() {
        return null;
    }

    @Nullable
    public LocalVcsItemsLocker getItemsLocker() {
        return null;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void directoryMappingChanged() {
    }

    public boolean markExternalChangesAsUpToDate() {
        return false;
    }

    public void start() throws VcsException {
        this.myIsStarted = true;
    }

    public void shutdown() throws VcsException {
        LOG.assertTrue(this.myIsStarted, "Attempt to shut down VCS " + this.getClass().getName() + " which was not started");
        this.myIsStarted = false;
    }

    @Nullable
    public CheckinEnvironment getCheckinEnvironment() {
        return null;
    }

    @Nullable
    public RollbackEnvironment getRollbackEnvironment() {
        return null;
    }

    @Nullable
    public VcsHistoryProvider getVcsHistoryProvider() {
        return null;
    }

    @Nullable
    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return null;
    }

    public String getMenuItemText() {
        return this.getDisplayName();
    }

    @Nullable
    public UpdateEnvironment getUpdateEnvironment() {
        return null;
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        return true;
    }

    public boolean fileExistsInVcs(FilePath path) {
        VirtualFile virtualFile = path.getVirtualFile();
        if (virtualFile != null) {
            FileStatus fileStatus = FileStatusManager.getInstance(this.myProject).getStatus(virtualFile);
            return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED;
        }
        return true;
    }

    @Nullable
    public UpdateEnvironment getStatusEnvironment() {
        return null;
    }

    @Nullable
    public AnnotationProvider getAnnotationProvider() {
        return null;
    }

    @Nullable
    public DiffProvider getDiffProvider() {
        return null;
    }

    public VcsShowSettingOption getUpdateOptions() {
        return this.myUpdateOption;
    }

    public VcsShowSettingOption getStatusOptions() {
        return this.myStatusOption;
    }

    public void loadSettings() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        if (this.getUpdateEnvironment() != null) {
            this.myUpdateOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.UPDATE, this);
        }
        if (this.getStatusEnvironment() != null) {
            this.myStatusOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.STATUS, this);
        }
    }

    public FileStatus[] getProvidedStatuses() {
        return null;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return null;
    }

    @Nullable
    public UpdateEnvironment getIntegrateEnvironment() {
        return null;
    }

    @Nullable
    public CommittedChangesProvider getCommittedChangesProvider() {
        return null;
    }

    @Nullable
    public final CachingCommittedChangesProvider getCachingCommittedChangesProvider() {
        CommittedChangesProvider provider = this.getCommittedChangesProvider();
        if (provider instanceof CachingCommittedChangesProvider) {
            return (CachingCommittedChangesProvider)provider;
        }
        return null;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        return null;
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return false;
    }

    @Nullable
    public UnnamedConfigurable getRootConfigurable(VcsDirectoryMapping mapping) {
        return null;
    }
}

