/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    @NonNls
    private static final String VOWELS = "aeiouy";
    @NonNls
    private static final String[] ourPrepositions = new String[]{"at", "the", "and", "not", "if", "a", "or", "to", "in", "on", "into"};
    @NonNls
    private static final String[] REPLACES_REFS = new String[]{"&lt;", "&nbsp;", "&gt;", "&amp;", "&apos;", "&quot;"};
    @NonNls
    private static final String[] REPLACES_DISP = new String[]{"<", "\u00a0", ">", "&", "'", "\""};

    public static String replace(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @Nullable String newS) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (oldS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        return StringUtil.replace(text, oldS, newS, false);
    }

    public static String replaceIgnoreCase(@NotNull String text, @NotNull String oldS, @Nullable String newS) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceIgnoreCase must not be null");
        }
        if (oldS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceIgnoreCase must not be null");
        }
        return StringUtil.replace(text, oldS, newS, true);
    }

    public static void replaceChar(@NotNull char[] buffer, char oldChar, char newChar, int start, int end) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceChar must not be null");
        }
        for (int i = start; i < end; ++i) {
            char c = buffer[i];
            if (c != oldChar) continue;
            buffer[i] = newChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replace(@NotNull String text, @NotNull String oldS, @Nullable String newS, boolean ignoreCase) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (oldS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replace must not be null");
        }
        if (text.length() < oldS.length()) {
            return text;
        }
        String text1 = ignoreCase ? text.toLowerCase() : text;
        String oldS1 = ignoreCase ? oldS.toLowerCase() : oldS;
        StringBuilder newText = StringBuilderSpinAllocator.alloc();
        try {
            int i = 0;
            while (i < text1.length()) {
                int i1 = text1.indexOf(oldS1, i);
                if (i1 < 0) {
                    if (i == 0) {
                        String string = text;
                        return string;
                    }
                    newText.append(text, i, text.length());
                    break;
                }
                if (newS == null) {
                    String string = null;
                    return string;
                }
                newText.append(text, i, i1);
                newText.append(newS);
                i = i1 + oldS.length();
            }
            String string = newText.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose(newText);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getShortName must not be null");
        }
        String string = StringUtil.getShortName(fqName, '.');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getShortName(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getShortName must not be null");
        }
        String string = StringUtil.getShortName(aClass.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
        }
        return string;
    }

    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfIgnoreCase must not be null");
        }
        if (what == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.indexOfIgnoreCase must not be null");
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(String where, String what) {
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    public static boolean endsWithIgnoreCase(@NonNls String str, @NonNls String suffix) {
        int suffixLength;
        int stringLength = str.length();
        return stringLength >= (suffixLength = suffix.length()) && str.regionMatches(true, stringLength - suffixLength, suffix, 0, suffixLength);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        int prefixLength;
        int stringLength = str.length();
        return stringLength >= (prefixLength = prefix.length()) && str.regionMatches(true, 0, prefix, 0, prefixLength);
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtil.toUpperCase(a) == StringUtil.toUpperCase(b) || StringUtil.toLowerCase(a) == StringUtil.toLowerCase(b);
    }

    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a >= 'a' && a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a >= 'A' && a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getShortName(@NotNull String fqName, char separator) {
        String string;
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getShortName must not be null");
        }
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx >= 0) {
            string = fqName.substring(lastPointIdx + 1);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
            return string;
        }
        string = fqName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getShortName must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getPackageName must not be null");
        }
        String string = StringUtil.getPackageName(fqName, '.');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getPackageName must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getPackageName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getPackageName must not be null");
        }
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx < 0) return "";
        String string = fqName.substring(0, lastPointIdx);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getPackageName must not return null");
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        String string = StringUtil.convertLineSeparators(text, "\n", null);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        String string = StringUtil.convertLineSeparators(text, newSeparator, null);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not be null");
        }
        StringBuilder buffer = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                buffer.append(newSeparator);
                StringUtil.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (c == '\r') {
                buffer.append(newSeparator);
                if (i < text.length() - 1 && text.charAt(i + 1) == '\n') {
                    ++i;
                    StringUtil.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtil.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.convertLineSeparators must not return null");
        }
        return string;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            if (offset < changeOffset + oldLength) continue;
            int n = i;
            offsets[n] = offsets[n] + shift;
        }
    }

    public static int getLineBreakCount(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getLineBreakCount must not be null");
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public static int lineColToOffset(@NotNull CharSequence text, int line, int col) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.lineColToOffset must not be null");
        }
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    public static int offsetToLineNumber(@NotNull CharSequence text, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.offsetToLineNumber must not be null");
        }
        int curLine = 0;
        int curOffset = 0;
        while (offset > curOffset) {
            if (curOffset == text.length()) {
                return -1;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (curOffset < text.length() - 1 && text.charAt(curOffset + 1) == '\n') {
                    ++curOffset;
                }
            }
            ++curOffset;
        }
        return curLine;
    }

    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.difference must not be null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.difference must not be null");
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.wordsToBeginFromUpperCase must not be null");
        }
        StringBuffer buffer = null;
        int i = 0;
        while (true) {
            block11: {
                int j;
                char currChar;
                block12: {
                    String string;
                    block10: {
                        if (i >= s.length()) break block10;
                        char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
                        currChar = s.charAt(i);
                        if (Character.isLetterOrDigit(prevChar) || !Character.isLetterOrDigit(currChar) || Character.isUpperCase(currChar)) break block11;
                        break block12;
                    }
                    if (buffer == null) {
                        string = s;
                        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.wordsToBeginFromUpperCase must not return null");
                        return string;
                    }
                    string = buffer.toString();
                    if (string != null) return string;
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.wordsToBeginFromUpperCase must not return null");
                }
                for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
                }
                if (!StringUtil.isPreposition(s, i, j - 1)) {
                    if (buffer == null) {
                        buffer = new StringBuffer(s);
                    }
                    buffer.setCharAt(i, StringUtil.toUpperCase(currChar));
                }
            }
            ++i;
        }
    }

    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.isPreposition must not be null");
        }
        for (String preposition : ourPrepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == preposition.charAt(j)) continue;
                    found = false;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static void escapeStringCharacters(int length, String str, @NotNull @NonNls StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        block9: for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String hexCode = Integer.toHexString(ch).toUpperCase();
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        continue block9;
                    }
                    buffer.append(ch);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not be null");
        }
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        StringUtil.escapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.escapeStringCharacters must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(buffer);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not be null");
        }
        StringBuffer buffer = new StringBuffer();
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.unescapeStringCharacters must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String unquoteString(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unquoteString must not be null");
        }
        if (s.length() > 1 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            string = s.substring(1, s.length() - 1);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.unquoteString must not return null");
            return string;
        }
        string = s;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.unquoteString must not return null");
    }

    private static void unescapeStringCharacters(int length, String s, StringBuffer buffer) {
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.valueOf(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String pluralize(@NotNull String suggestion) {
        String string;
        if (suggestion == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.pluralize must not be null");
        }
        if (suggestion.endsWith("Child") || suggestion.endsWith("child")) {
            string = suggestion + "ren";
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        if (StringUtil.endsWithChar(suggestion, 's') || StringUtil.endsWithChar(suggestion, 'x') || suggestion.endsWith("ch")) {
            string = suggestion + "es";
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        int len = suggestion.length();
        if (StringUtil.endsWithChar(suggestion, 'y') && len > 1 && !StringUtil.isVowel(suggestion.charAt(len - 2))) {
            string = suggestion.substring(0, len - 1) + "ies";
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        string = suggestion + "s";
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String capitalizeWords(@NotNull String text, boolean allWords) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalizeWords must not be null");
        }
        java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(text);
        String out = "";
        String delim = "";
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            out = out + delim + (toCapitalize ? StringUtil.capitalize(word) : word);
            delim = " ";
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalizeWords must not return null");
        }
        return string;
    }

    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    public static boolean isVowel(char c) {
        return VOWELS.indexOf(c) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String capitalize(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.capitalize must not be null");
        }
        if (s.length() == 0) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        if (s.length() == 1) {
            string = s.toUpperCase();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            string = s;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
            return string;
        }
        string = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.capitalize must not return null");
    }

    public static int stringHashCode(CharSequence chars) {
        if (chars instanceof String) {
            return chars.hashCode();
        }
        if (chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        if (chars instanceof CharArrayCharSequence) {
            return chars.hashCode();
        }
        int h = 0;
        int to = chars.length();
        for (int off = 0; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    public static int stringHashCode(CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    public static int stringHashCodeInsensitive(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    public static int stringHashCodeInsensitive(CharSequence chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stringHashCodeInsensitive must not be null");
        }
        int h = 0;
        int len = chars.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(i));
        }
        return h;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimEnd must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimEnd must not be null");
        }
        if (s.endsWith(suffix)) {
            string = s.substring(0, s.lastIndexOf(suffix));
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimEnd must not return null");
            return string;
        }
        string = s;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimEnd must not return null");
    }

    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimStart must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.trimStart must not be null");
        }
        if (s.startsWith(prefix)) {
            string = s.substring(prefix.length());
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimStart must not return null");
            return string;
        }
        string = s;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.trimStart must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String pluralize(@NotNull String base, int n) {
        String string;
        if (base == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.pluralize must not be null");
        }
        if (n == 1) {
            string = base;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
            return string;
        }
        string = StringUtil.pluralize(base);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.pluralize must not return null");
    }

    public static void repeatSymbol(Appendable buffer, char symbol, int times) {
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String notNullize(String s) {
        if (s == null) {
            return "";
        }
        String string = s;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.notNullize must not return null");
        return string;
    }

    public static boolean isEmptyOrSpaces(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String getThrowableText(Throwable aThrowable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        aThrowable.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    public static String getThrowableText(Throwable aThrowable, @NonNls @NotNull String stackFrameSkipPattern) {
        if (stackFrameSkipPattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getThrowableText must not be null");
        }
        String prefix = "\tat ";
        final String skipPattern = "\tat " + stackFrameSkipPattern;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter){
            boolean skipping;
            {
                super(x0);
                this.skipping = false;
            }

            public void println(String x) {
                if (x != null) {
                    if (!this.skipping && x.startsWith(skipPattern)) {
                        this.skipping = true;
                    } else if (this.skipping && !x.startsWith("\tat ")) {
                        this.skipping = false;
                    }
                }
                if (this.skipping) {
                    return;
                }
                super.println(x);
            }
        };
        aThrowable.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    public static String getMessage(Throwable e) {
        String result = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while ((result == null || result.contains("Exception: ") || result.contains("Error: ")) && e.getCause() != null) {
            e = e.getCause();
            result = e.getMessage();
        }
        if (result != null) {
            result = StringUtil.extractMessage(result, "Exception: ");
            result = StringUtil.extractMessage(result, "Error: ");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String extractMessage(@NotNull String result, @NotNull String errorPattern) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.extractMessage must not be null");
        }
        if (errorPattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.extractMessage must not be null");
        }
        if (result.lastIndexOf(errorPattern) >= 0) {
            result = result.substring(result.lastIndexOf(errorPattern) + errorPattern.length());
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.extractMessage must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String repeatSymbol(char aChar, int count) {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        StringUtil.repeatSymbol(buffer, aChar, count);
        String string = buffer.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.repeatSymbol must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.splitHonorQuotes must not be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            boolean inQuotes = false;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == separator && !inQuotes) {
                    if (builder.length() <= 0) continue;
                    result.add(builder.toString());
                    builder.setLength(0);
                    continue;
                }
                if (c == '\"' && (i <= 0 || s.charAt(i - 1) != '\\')) {
                    inQuotes = !inQuotes;
                }
                builder.append(c);
            }
            if (builder.length() > 0) {
                result.add(builder.toString());
            }
        }
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.splitHonorQuotes must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        ArrayList<String> result;
        List<String> list;
        block11: {
            if (s == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
            }
            if (separator == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.split must not be null");
            }
            if (separator.length() == 0) {
                list = Collections.singletonList(s);
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
                return list;
            }
            result = new ArrayList<String>();
            int pos = 0;
            while (true) {
                int index;
                if ((index = s.indexOf(separator, pos)) == -1) {
                    if (pos < s.length()) {
                        break;
                    }
                    break block11;
                }
                String token = s.substring(pos, index);
                if (token.length() != 0) {
                    result.add(token);
                }
                pos = index + separator.length();
            }
            result.add(s.substring(pos, s.length()));
        }
        if ((list = result) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.split must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.tokenize must not be null");
        }
        if (separators == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.tokenize must not be null");
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.tokenize must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<String> getWordsIn(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.getWordsIn must not be null");
        }
        SmartList<String> result = new SmartList<String>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(text.substring(start, i));
            start = -1;
        }
        SmartList<String> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.getWordsIn must not return null");
        }
        return smartList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String join(@NotNull String[] strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        String string = StringUtil.join(strings, 0, strings.length, separator);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String join(@NotNull String[] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(result);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String[] zip(@NotNull String[] strings1, @NotNull String[] strings2, String separator) {
        if (strings1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.zip must not be null");
        }
        if (strings2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.zip must not be null");
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = new String[strings1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.zip must not return null");
        }
        return result;
    }

    public static String[] surround(String[] strings1, String prefix, String suffix) {
        String[] result = new String[strings1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings1[i] + suffix;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> String join(@NotNull Collection<T> items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.length() == 0) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        String string = result.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        for (String string : strings) {
            if (string == null || string.length() == 0) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        String string = result.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String join(@NotNull int[] strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.join must not be null");
        }
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.join must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose(result);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String stripQuotesAroundValue(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.stripQuotesAroundValue must not be null");
        }
        if (StringUtil.startsWithChar(text, '\"') || StringUtil.startsWithChar(text, '\'')) {
            text = text.substring(1);
        }
        if (StringUtil.endsWithChar(text, '\"') || StringUtil.endsWithChar(text, '\'')) {
            text = text.substring(0, text.length() - 1);
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.stripQuotesAroundValue must not return null");
        }
        return string;
    }

    public static boolean isQuotedString(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.isQuotedString must not be null");
        }
        return StringUtil.startsWithChar(text, '\"') && StringUtil.endsWithChar(text, '\"') || StringUtil.startsWithChar(text, '\'') && StringUtil.endsWithChar(text, '\'');
    }

    @NotNull
    public static String formatFileSize(long fileSize) {
        long mbytes;
        String size;
        long kbytes;
        String kbs;
        String string;
        if (!(fileSize < 1024L ? (string = CommonBundle.message("file.size.format.bytes", fileSize)) != null : (fileSize < 0x100000L ? (string = CommonBundle.message("file.size.format.kbytes", kbs = (kbytes = fileSize * 100L / 1024L) / 100L + "." + kbytes % 100L)) != null : (string = CommonBundle.message("file.size.format.mbytes", size = (mbytes = fileSize * 100L / 1024L / 1024L) / 100L + "." + mbytes % 100L)) != null))) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.formatFileSize must not return null");
        }
        return string;
    }

    @Nullable
    public static String unpluralize(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.unpluralize must not be null");
        }
        if (name.endsWith("sses") || name.endsWith("shes") || name.endsWith("ches") || name.endsWith("xes")) {
            return name.substring(0, name.length() - 2);
        }
        if (name.endsWith("ses")) {
            return name.substring(0, name.length() - 1);
        }
        if (name.endsWith("ies")) {
            return name.substring(0, name.length() - 3) + "y";
        }
        String result = StringUtil.stripEnding(name, "s");
        if (result != null) {
            return result;
        }
        if (name.endsWith("children")) {
            return name.substring(0, name.length() - "children".length()) + "child";
        }
        if (name.endsWith("Children") && name.length() > "Children".length()) {
            return name.substring(0, name.length() - "Children".length()) + "Child";
        }
        return null;
    }

    private static String stripEnding(String name, String ending) {
        if (name.endsWith(ending)) {
            if (name.equals(ending)) {
                return name;
            }
            return name.substring(0, name.length() - 1);
        }
        return null;
    }

    public static boolean containsAlphaCharacters(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.containsAlphaCharacters must not be null");
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String firstLetterToUpperCase(String displayString) {
        if (displayString == null || displayString.length() == 0) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        StringBuilder builder = new StringBuilder(displayString);
        builder.setCharAt(0, uppedFirstChar);
        return builder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.strip must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.strip must not be null");
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.strip must not return null");
        }
        return string;
    }

    public static int findFirst(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.findFirst must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.findFirst must not be null");
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceSubstring must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceSubstring must not be null");
        }
        if (replacement == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.replaceSubstring must not be null");
        }
        String string2 = string.substring(0, range.getStartOffset()) + replacement + string.substring(range.getEndOffset());
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.replaceSubstring must not return null");
        }
        return string2;
    }

    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWith must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.startsWith must not be null");
        }
        int l1 = text.length();
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWith must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.endsWith must not be null");
        }
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonPrefix must not be null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonPrefix must not be null");
        }
        for (i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        String string = s1.substring(0, i);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.commonPrefix must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonSuffix must not be null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.commonSuffix must not be null");
        }
        if (s1.length() == 0) return "";
        if (s2.length() == 0) {
            return "";
        }
        for (i = s1.length() - 1; i >= 0 && i >= s1.length() - s2.length() && s1.charAt(i) == s2.charAt(i + s2.length() - s1.length()); --i) {
        }
        String string = s1.substring(i, s1.length());
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/text/StringUtil.commonSuffix must not return null");
        return string2;
    }

    public static int indexOf(CharSequence s, char c) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static String first(String text, int length, boolean appendEllipsis) {
        return text.length() > length ? text.substring(0, length) + (appendEllipsis ? "..." : "") : text;
    }

    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/text/StringUtil.escapeQuotes must not be null");
        }
        int idx = str.indexOf(34);
        if (idx < 0) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (idx < buf.length()) {
            if (buf.charAt(idx) == '\"') {
                buf.replace(idx, idx + 1, "\\\"");
                idx += 2;
                continue;
            }
            ++idx;
        }
        return buf.toString();
    }

    public static String unescapeXml(String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_REFS, REPLACES_DISP);
    }

    public static String escapeXml(String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_DISP, REPLACES_REFS);
    }

    public static String escapeToRegexp(String text) {
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c)) {
                result.append(c);
                continue;
            }
            result.append('\\').append(c);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String replace(String text, String[] from, String[] to) {
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        try {
            block3: for (int i = 0; i < text.length(); ++i) {
                for (int j = 0; j < from.length; ++j) {
                    String toReplace = from[j];
                    String replaceWith = to[j];
                    int len = toReplace.length();
                    if (!text.regionMatches(i, toReplace, 0, len)) continue;
                    result.append(replaceWith);
                    i += len - 1;
                    continue block3;
                }
                result.append(text.charAt(i));
            }
            String string = result.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose(result);
        }
    }

    public static String[] filterEmptyStrings(String[] strings) {
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && string.length() != 0) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            return strings;
        }
        String[] result = new String[strings.length - emptyCount];
        int count = 0;
        for (String string : strings) {
            if (string == null || string.length() == 0) continue;
            result[count++] = string;
        }
        return result;
    }
}

