/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;

public class LineTokenizer {
    private int myOffset = 0;
    private int myLength = 0;
    private int myLineSeparatorLength = 0;
    private boolean atEnd = false;
    private CharSequence myText;

    public static String[] tokenize(CharSequence chars, boolean includeSeparators) {
        return LineTokenizer.tokenize(chars, includeSeparators, true);
    }

    private static String[] tokenize(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null || chars.length() == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        LineTokenizer tokenizer = new LineTokenizer(chars);
        ArrayList<String> lines = new ArrayList<String>();
        while (!tokenizer.atEnd()) {
            int offset = tokenizer.getOffset();
            String line = includeSeparators ? ((Object)chars.subSequence(offset, offset + tokenizer.getLength() + tokenizer.getLineSeparatorLength())).toString() : ((Object)chars.subSequence(offset, offset + tokenizer.getLength())).toString();
            lines.add(line);
            tokenizer.advance();
        }
        if (!skipLastEmptyLine && LineTokenizer.stringEdnsWithSeparator(tokenizer)) {
            lines.add("");
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String[] tokenize(char[] chars, boolean includeSeparators) {
        return LineTokenizer.tokenize(chars, includeSeparators, true);
    }

    public static String[] tokenize(char[] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        return LineTokenizer.tokenize(chars, 0, chars.length, includeSeparators, skipLastEmptyLine);
    }

    public static String[] tokenize(char[] chars, int startOffset, int endOffset, boolean includeSeparators, boolean skipLastEmptyLine) {
        return LineTokenizer.tokenize(new CharArrayCharSequence(chars, startOffset, endOffset), includeSeparators, skipLastEmptyLine);
    }

    private static boolean stringEdnsWithSeparator(LineTokenizer tokenizer) {
        return tokenizer.getLineSeparatorLength() > 0;
    }

    public static String[] tokenize(char[] chars, int startOffset, int endOffset, boolean includeSeparators) {
        return LineTokenizer.tokenize(chars, startOffset, endOffset, includeSeparators, true);
    }

    public LineTokenizer(CharSequence text) {
        this.myText = text;
        this.myOffset = 0;
        this.advance();
    }

    public LineTokenizer(char[] text, int startOffset, int endOffset) {
        this(new CharArrayCharSequence(text, startOffset, endOffset));
    }

    public final boolean atEnd() {
        return this.atEnd;
    }

    public final int getOffset() {
        return this.myOffset;
    }

    public final int getLength() {
        return this.myLength;
    }

    public final int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c;
        int i = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i < textLength && (c = this.myText.charAt(i)) != '\r' && c != '\n') {
            ++i;
        }
        this.myOffset = this.myOffset + this.myLength + this.myLineSeparatorLength;
        this.myLength = i - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i == textLength) {
            return;
        }
        char first = this.myText.charAt(i);
        if (first == '\r' || first == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i == textLength) {
            return;
        }
        char second = this.myText.charAt(i);
        if (first == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }
}

