/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.process;

import com.intellij.openapi.util.process.InterruptibleActivity;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public abstract class InterruptibleProcess
extends InterruptibleActivity {
    private final Process myProcess;
    private InputStream myInputStream;
    private InputStream myErrorStream;
    private int myExitCode;

    protected InterruptibleProcess(Process process, long timeout, TimeUnit timeUnit) {
        super(timeout, timeUnit);
        this.myProcess = process;
        this.myInputStream = new InputStreamWrapper(process.getInputStream());
        this.myErrorStream = new InputStreamWrapper(process.getErrorStream());
    }

    public final InputStream getErrorStream() {
        return this.myErrorStream;
    }

    public final InputStream getInputStream() {
        return this.myInputStream;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    protected void interrupt() {
        try {
            this.myInputStream.close();
            this.myErrorStream.close();
            this.myProcess.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void start() {
        try {
            this.myExitCode = this.myProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private class InputStreamWrapper
    extends InputStream {
        private InputStream myDelegate;

        public InputStreamWrapper(InputStream delegate) {
            this.myDelegate = delegate;
        }

        public int read() throws IOException {
            int r = this.myDelegate.read();
            InterruptibleProcess.this.touch();
            return r;
        }

        public int read(byte[] b) throws IOException {
            int r = this.myDelegate.read(b);
            InterruptibleProcess.this.touch();
            return r;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.myDelegate.read(b, off, len);
            InterruptibleProcess.this.touch();
            return r;
        }
    }
}

