/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.process;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InterruptibleActivity {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.process.InterruptibleActivity");
    private volatile boolean myIsTouched = true;
    private final long myTimeout;
    private final TimeUnit myTimeUnit;

    protected InterruptibleActivity(long timeout, TimeUnit timeUnit) {
        this.myTimeout = timeout;
        this.myTimeUnit = timeUnit;
    }

    public final void touch() {
        this.myIsTouched = true;
    }

    private boolean isTouched() {
        boolean touched = this.myIsTouched;
        this.myIsTouched = false;
        return touched;
    }

    protected abstract void start();

    protected abstract void interrupt();

    protected abstract int processTimeout();

    public final int execute() {
        Application application = ApplicationManager.getApplication();
        Future<?> future = application.executeOnPooledThread(new Runnable(){

            public void run() {
                InterruptibleActivity.this.start();
            }
        });
        int rc = this.waitForFuture(future);
        if (rc != 0) {
            application.executeOnPooledThread(new Runnable(){

                public void run() {
                    InterruptibleActivity.this.interrupt();
                }
            });
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int waitForFuture(Future<?> future) {
        while (true) {
            try {
                future.get(this.myTimeout, this.myTimeUnit);
            }
            catch (InterruptedException e) {
                InterruptibleActivity.LOG.error(e);
                continue;
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                if (!this.isTouched() && (retCode = this.processTimeoutInEDT()) != 0) ** break;
                continue;
                return future.isDone() != false ? 0 : retCode;
            }
            break;
        }
        return 0;
    }

    protected int processTimeoutInEDT() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return this.processTimeout();
        }
        final int[] retcode = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    retcode[0] = InterruptibleActivity.this.processTimeout();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retcode[0];
    }
}

