/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectTree {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private Set<Object> myRootObjects = new THashSet();
    private Map<Object, ObjectNode> myObject2NodeMap = new THashMap();
    private List<ObjectNode> myExecutedObjects = new ArrayList<ObjectNode>();

    public final Map<Object, ObjectNode> getObject2NodeMap() {
        return this.myObject2NodeMap;
    }

    public final List<ObjectNode> getExecutedObjects() {
        return this.myExecutedObjects;
    }

    public final Set getRootObjects() {
        return this.myRootObjects;
    }

    public final void register(Object parent, Object child) {
        this.checkIfValid(child);
        ObjectNode parentNode = this.getNodeFor(parent);
        ObjectNode childNode = this.getNodeFor(child);
        if (childNode != null && childNode.getParent() != parentNode && childNode.getParent() != null) {
            childNode.getParent().removeChild(childNode);
            parentNode.addChild(childNode);
        } else if (this.myRootObjects.contains(child)) {
            ObjectNode parentless = this.getNodeFor(child);
            parentNode.addChild(parentless);
            this.myRootObjects.remove(child);
        } else {
            parentNode.addChild(child);
        }
    }

    private void checkIfValid(Object child) {
        boolean childIsInTree;
        ObjectNode childNode = this.myObject2NodeMap.get(child);
        boolean bl = childIsInTree = childNode != null && childNode.getParent() != null;
        if (!childIsInTree) {
            return;
        }
        for (ObjectNode eachParent = childNode.getParent(); eachParent != null; eachParent = eachParent.getParent()) {
            if (eachParent.getObject() != child) continue;
            LOG.assertTrue(false, child + " was already added as a child of: " + eachParent);
        }
    }

    private ObjectNode getNodeFor(Object parentObject) {
        ObjectNode parentNode = this.getObject2NodeMap().get(parentObject);
        if (parentNode != null) {
            return parentNode;
        }
        ObjectNode parentless = new ObjectNode(this, null, parentObject);
        this.myRootObjects.add(parentObject);
        this.getObject2NodeMap().put(parentObject, parentless);
        return parentless;
    }

    public final void executeAll(Object object, boolean disposeTree, ObjectTreeAction action) {
        assert (object != null) : "Unable execute action for null object";
        ObjectNode node = this.getObject2NodeMap().get(object);
        if (node != null) {
            node.execute(disposeTree, action);
        } else {
            action.execute(object);
        }
    }

    public final void executeChildAndReplace(Object toExecute, Object toReplace, boolean disposeTree, ObjectTreeAction action) {
        ObjectNode toExecuteNode = this.getObject2NodeMap().get(toExecute);
        assert (toExecuteNode != null) : "Object " + toExecute + " wasn't registered or already disposed";
        ObjectNode parent = toExecuteNode.getParent();
        assert (parent != null) : "Object " + toExecute + " is not connected to the tree - doesn't have parent";
        toExecuteNode.execute(disposeTree, action);
        this.register(parent.getObject(), toReplace);
    }

    public final boolean isRegistered(Object object) {
        return this.getObject2NodeMap().containsKey(object);
    }

    public final Object getParent(Object object) {
        ObjectNode parent = this.getObject2NodeMap().get(object).getParent();
        if (parent == null) {
            return null;
        }
        return parent.getObject();
    }

    public boolean isRoot(Object object) {
        return this.myRootObjects.contains(object);
    }
}

