/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectNode {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectNode");
    private ObjectTree myTree;
    private ObjectNode myParent;
    private Object myObject;
    private LinkedHashSet<ObjectNode> myChildren;
    private Throwable myTrace;

    public ObjectNode(ObjectTree tree, ObjectNode parentNode, Object object) {
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        if (Disposer.isDebugMode()) {
            this.myTrace = new Throwable();
        }
    }

    public void addChild(Object childObject) {
        this.ensureChildArray();
        ObjectNode childNode = new ObjectNode(this.myTree, this, childObject);
        this._add(childNode);
    }

    public void addChild(ObjectNode child) {
        this.ensureChildArray();
        this._add(child);
    }

    public void removeChild(ObjectNode child) {
        this._remove(child);
    }

    private void setParent(ObjectNode parent) {
        this.myParent = parent;
    }

    public ObjectNode getParent() {
        return this.myParent;
    }

    private void _add(ObjectNode child) {
        child.setParent(this);
        this.myChildren.add(child);
        this.myTree.getObject2NodeMap().put(child.getObject(), child);
    }

    private void _remove(ObjectNode child) {
        assert (this.myChildren != null) : "No chindren to remove child: " + this + ' ' + child;
        if (this.myChildren.remove(child)) {
            child.setParent(null);
            this.myTree.getObject2NodeMap().remove(child.getObject());
        }
    }

    private void ensureChildArray() {
        if (this.myChildren == null) {
            this.myChildren = new LinkedHashSet();
        }
    }

    public void execute(boolean disposeTree, ObjectTreeAction action) {
        if (this.myTree.getExecutedObjects().contains(this)) {
            return;
        }
        this.myTree.getExecutedObjects().add(this);
        action.beforeTreeExecution(this.myObject);
        if (this.myChildren != null) {
            ObjectNode[] children = this.myChildren.toArray(new ObjectNode[this.myChildren.size()]);
            for (int i = children.length - 1; i >= 0; --i) {
                children[i].execute(disposeTree, action);
            }
        }
        if (disposeTree) {
            this.myChildren = null;
        }
        try {
            action.execute(this.myObject);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        if (disposeTree) {
            this.myTree.getObject2NodeMap().remove(this.myObject);
            if (this.myParent != null) {
                this.myParent.removeChild(this);
            } else {
                this.myTree.getRootObjects().remove(this.myObject);
            }
        }
        this.myTree.getExecutedObjects().remove(this);
    }

    public Object getObject() {
        return this.myObject;
    }

    public Collection<ObjectNode> getChildren() {
        return this.myChildren;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject.toString();
    }

    public Throwable getTrace() {
        return this.myTrace;
    }
}

