/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.CommonBundle;
import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final int MEGABYTE = 0x100000;
    private static final Logger LOG;
    private static final ThreadLocal<byte[]> BUFFER;
    private static final Method IO_FILE_SET_WRITABLE_METHOD;

    @Nullable
    public static String getRelativePath(File base, File file) {
        int len;
        String filePathToCompare;
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        String filePath = file.getAbsolutePath();
        int lastSeparatorIndex = 0;
        String basePathToCompare = SystemInfo.isFileSystemCaseSensitive ? basePath : basePath.toLowerCase();
        String string = filePathToCompare = SystemInfo.isFileSystemCaseSensitive ? filePath : filePath.toLowerCase();
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != File.separatorChar) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != File.separatorChar) continue;
            relativePath.append("..");
            relativePath.append(File.separatorChar);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) throws IOException {
        File parent;
        File file2 = parent = strict ? FileUtil.getParentFile(file) : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = FileUtil.getParentFile(parent);
        }
        return false;
    }

    @Nullable
    public static File getParentFile(File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static char[] loadFileText(File file) throws IOException {
        return FileUtil.loadFileText(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] loadFileText(File file, @NonNls String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
        try {
            char[] cArray = FileUtil.loadText(reader, (int)file.length());
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public static char[] loadText(Reader reader, int length) throws IOException {
        int count;
        int n;
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            return chars;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        return newChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileBytes(File file) throws IOException {
        byte[] bytes;
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            bytes = FileUtil.loadBytes(stream, (int)file.length());
        }
        finally {
            ((InputStream)stream).close();
        }
        return bytes;
    }

    public static byte[] loadBytes(InputStream stream, int length) throws IOException {
        int n;
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String loadTextAndClose(Reader reader) throws IOException {
        String string = new String(FileUtil.adaptiveLoadText(reader));
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadTextAndClose must not return null");
        }
        return string2;
        finally {
            reader.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] adaptiveLoadText(Reader reader) throws IOException {
        char[] result;
        int total;
        char[] chars;
        block6: {
            chars = new char[4096];
            ArrayList<char[]> buffers = null;
            int count = 0;
            total = 0;
            while (true) {
                int n;
                if ((n = reader.read(chars, count, chars.length - count)) <= 0) {
                    result = new char[total];
                    if (buffers != null) {
                        break;
                    }
                    break block6;
                }
                total += n;
                if ((count += n) != chars.length) continue;
                if (buffers == null) {
                    buffers = new ArrayList<char[]>();
                }
                buffers.add(chars);
                chars = new char[chars.length * 2];
                count = 0;
            }
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result, result.length - total, total);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.adaptiveLoadText must not return null");
        }
        return result;
    }

    public static byte[] adaptiveLoadBytes(InputStream stream) throws IOException {
        int n;
        byte[] bytes = new byte[4096];
        ArrayList<byte[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = stream.read(bytes, count, bytes.length - count)) > 0) {
            total += n;
            if ((count += n) != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            bytes = new byte[bytes.length * 2];
            count = 0;
        }
        byte[] result = new byte[total];
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result, result.length - total, total);
        return result;
    }

    public static File createTempDirectory(@NonNls String prefix, @NonNls String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix);
        file.delete();
        file.mkdir();
        return file;
    }

    public static File createTempFile(@NonNls String prefix, @NonNls String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix);
        file.delete();
        file.createNewFile();
        return file;
    }

    private static File doCreateTempFile(String prefix, String suffix) throws IOException {
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        int exceptionsCount = 0;
        while (true) {
            try {
                return File.createTempFile(prefix, suffix).getCanonicalFile();
            }
            catch (IOException e) {
                if (++exceptionsCount < 100) continue;
                throw e;
            }
            break;
        }
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void asyncDelete(File file) {
        File tempFile = FileUtil.renameToTempFileOrDelete(file);
        if (tempFile == null) {
            return;
        }
        FileUtil.startDeletionThread(tempFile);
    }

    public static void asyncDelete(Collection<File> files) {
        ArrayList<File> tempFiles = new ArrayList<File>();
        for (File file : files) {
            File tempFile = FileUtil.renameToTempFileOrDelete(file);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
        }
        if (!tempFiles.isEmpty()) {
            FileUtil.startDeletionThread(tempFiles.toArray(new File[tempFiles.size()]));
        }
    }

    private static void startDeletionThread(final File ... tempFiles) {
        Runnable deleteFilesTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread currentThread = Thread.currentThread();
                currentThread.setPriority(1);
                ShutDownTracker.getInstance().registerStopperThread(currentThread);
                try {
                    for (File tempFile : tempFiles) {
                        FileUtil.delete(tempFile);
                    }
                }
                finally {
                    ShutDownTracker.getInstance().unregisterStopperThread(currentThread);
                    currentThread.setPriority(5);
                }
            }
        };
        try {
            Class<?> aClass = Class.forName("com.intellij.openapi.application.ApplicationManager");
            Method getApplicationMethod = aClass.getMethod("getApplication", new Class[0]);
            Object application = getApplicationMethod.invoke(null, new Object[0]);
            Method executeOnPooledThreadMethod = application.getClass().getMethod("executeOnPooledThread", Runnable.class);
            executeOnPooledThreadMethod.invoke(application, deleteFilesTask);
        }
        catch (Exception e) {
            Thread t = new Thread(deleteFilesTask, "File deletion thread");
            t.start();
        }
    }

    private static File renameToTempFileOrDelete(File file) {
        String originalFileName;
        File tempFile;
        File tempDir = new File(FileUtil.getTempDirectory());
        boolean isSameDrive = true;
        if (SystemInfo.isWindows) {
            String tempDirDrive = tempDir.getAbsolutePath().substring(0, 2);
            String fileDrive = file.getAbsolutePath().substring(0, 2);
            isSameDrive = tempDirDrive.equalsIgnoreCase(fileDrive);
        }
        if (isSameDrive && file.renameTo(tempFile = FileUtil.getTempFile(originalFileName = file.getName(), tempDir))) {
            return tempFile;
        }
        FileUtil.delete(file);
        return null;
    }

    private static File getTempFile(String originalFileName, File parent) {
        int randomSuffix;
        int i = randomSuffix = (int)(System.currentTimeMillis() % 1000L);
        String name;
        File tempFile;
        while ((tempFile = new File(parent, name = "___" + originalFileName + i + ".__del__")).exists()) {
            ++i;
        }
        return tempFile;
    }

    public static boolean delete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File file1 : files) {
                FileUtil.delete(file1);
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete() || !file.exists()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean createParentDirs(File file) {
        String parentDirPath;
        if (!file.exists() && (parentDirPath = file.getParent()) != null) {
            File parentFile = new File(parentDirPath);
            return parentFile.exists() && parentFile.isDirectory() || parentFile.mkdirs();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File fromFile, File toFile) throws IOException {
        FileOutputStream fos;
        FileInputStream fis = new FileInputStream(fromFile);
        try {
            fos = new FileOutputStream(toFile);
        }
        catch (FileNotFoundException e) {
            File parentFile = toFile.getParentFile();
            if (parentFile == null) {
                return;
            }
            parentFile.mkdirs();
            toFile.createNewFile();
            fos = new FileOutputStream(toFile);
        }
        if (Patches.FILE_CHANNEL_TRANSFER_BROKEN) {
            try {
                FileUtil.copy(fis, fos);
            }
            finally {
                fis.close();
                fos.close();
            }
        }
        FileChannel fromChannel = fis.getChannel();
        FileChannel toChannel = fos.getChannel();
        try {
            fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
        }
        finally {
            fromChannel.close();
            toChannel.close();
        }
        toFile.setLastModified(fromFile.lastModified());
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = BUFFER.get();
        while ((read = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static void copyDir(File fromDir, File toDir) throws IOException {
        FileUtil.copyDir(fromDir, toDir, true);
    }

    public static void copyDir(File fromDir, File toDir, boolean copySystemFiles) throws IOException {
        toDir.mkdirs();
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] files = fromDir.listFiles();
        if (!fromDir.canRead()) {
            throw new IOException(CommonBundle.message("exception.directory.is.not.readable", fromDir.getPath()));
        }
        if (files == null) {
            throw new IOException(CommonBundle.message("exception.directory.is.invalid", fromDir.getPath()));
        }
        for (File file : files) {
            if (!copySystemFiles && file.getName().startsWith(".")) continue;
            if (file.isDirectory()) {
                FileUtil.copyDir(file, new File(toDir, file.getName()), copySystemFiles);
                continue;
            }
            FileUtil.copy(file, new File(toDir, file.getName()));
        }
    }

    public static String getNameWithoutExtension(File file) {
        return FileUtil.getNameWithoutExtension(file.getName());
    }

    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static String createSequentFileName(File aParentFolder, @NonNls String aFilePrefix, String aExtension) {
        return FileUtil.findSequentNonexistentFile(aParentFolder, aFilePrefix, aExtension).getName();
    }

    public static File findSequentNonexistentFile(File aParentFolder, @NonNls String aFilePrefix, String aExtension) {
        int postfix = 0;
        String ext = 0 == aExtension.length() ? "" : "." + aExtension;
        File candidate = new File(aParentFolder, aFilePrefix + ext);
        while (candidate.exists()) {
            candidate = new File(aParentFolder, aFilePrefix + Integer.toString(++postfix) + ext);
        }
        return candidate;
    }

    public static String toSystemDependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.toSystemDependentName must not be null");
        }
        return aFileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String toSystemIndependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.toSystemIndependentName must not be null");
        }
        return aFileName.replace('\\', '/');
    }

    public static String unquote(String urlString) {
        urlString = urlString.replace('/', File.separatorChar);
        return StringUtil.replace(urlString, "%20", " ");
    }

    public static boolean isFilePathAcceptable(File file, @Nullable FileFilter fileFilter) {
        do {
            if (fileFilter == null || fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static void rename(File source, File target) throws IOException {
        if (source.renameTo(target)) {
            return;
        }
        FileUtil.copy(source, target);
        FileUtil.delete(source);
    }

    public static boolean startsWith(@NonNls String path1, @NonNls String path2) {
        return FileUtil.startsWith(path1, path2, SystemInfo.isFileSystemCaseSensitive);
    }

    public static boolean startsWith(String path1, String path2, boolean caseSensitive) {
        int length1 = path1.length();
        int length2 = path2.length();
        if (length2 == 0) {
            return true;
        }
        if (length2 > length1) {
            return false;
        }
        if (!path1.regionMatches(!caseSensitive, 0, path2, 0, length2)) {
            return false;
        }
        if (length1 == length2) {
            return true;
        }
        char last2 = path2.charAt(length2 - 1);
        char next1 = last2 == '/' || last2 == File.separatorChar ? path1.charAt(length2 - 1) : path1.charAt(length2);
        return next1 == '/' || next1 == File.separatorChar;
    }

    public static boolean pathsEqual(String path1, String path2) {
        return SystemInfo.isFileSystemCaseSensitive ? path1.equals(path2) : path1.equalsIgnoreCase(path2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getExtension must not be null");
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        String string = fileName.substring(index + 1).toLowerCase();
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.getExtension must not return null");
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String resolveShortWindowsName(@NotNull String path) throws IOException {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not be null");
        }
        if (SystemInfo.isWindows) {
            string = new File(path.replace(File.separatorChar, '/')).getCanonicalPath();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not return null");
            return string;
        }
        string = path;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not return null");
    }

    public static void collectMatchedFiles(File root, Pattern pattern, List<File> files) {
        FileUtil.collectMatchedFiles(root, root, pattern, files);
    }

    private static void collectMatchedFiles(File absoluteRoot, File root, Pattern pattern, List<File> files) {
        File[] dirs = root.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path = FileUtil.toSystemIndependentName(FileUtil.getRelativePath(absoluteRoot, dir));
                if (!pattern.matcher(path).matches()) continue;
                files.add(dir);
                continue;
            }
            FileUtil.collectMatchedFiles(absoluteRoot, dir, pattern, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertAntToRegexp(String antPattern) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            boolean isTrailingSlash;
            int idx;
            int asteriskCount = 0;
            boolean recursive = true;
            int n = idx = antPattern.startsWith("/") || antPattern.startsWith("\\") ? 1 : 0;
            while (idx < antPattern.length()) {
                char ch = antPattern.charAt(idx);
                if (ch == '*') {
                    ++asteriskCount;
                } else {
                    boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
                    boolean asterisksFound = asteriskCount > 0;
                    asteriskCount = 0;
                    boolean bl = recursive = ch == '/' || ch == '\\';
                    if (foundRecursivePattern) {
                        builder.append("(?:[^/]+/)*?");
                    } else {
                        if (asterisksFound) {
                            builder.append("[^/]*?");
                        }
                        if (ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                            builder.append('\\').append(ch);
                        } else if (ch == '?') {
                            builder.append("[^/]{1}");
                        } else if (ch == '\\') {
                            builder.append('/');
                        } else {
                            builder.append(ch);
                        }
                    }
                }
                ++idx;
            }
            boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
            if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
                if (isTrailingSlash) {
                    builder.setLength(builder.length() - 1);
                }
                if (builder.length() == 0) {
                    builder.append(".*");
                } else {
                    builder.append("(?:$|/.+)");
                }
            } else if (asteriskCount > 0) {
                builder.append("[^/]*?");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
    }

    public static boolean moveDirWithContent(File fromDir, File toDir) {
        if (!toDir.exists()) {
            return fromDir.renameTo(toDir);
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            return false;
        }
        boolean success = true;
        for (File fromFile : files) {
            File toFile = new File(toDir, fromFile.getName());
            success = success && fromFile.renameTo(toFile);
        }
        fromDir.delete();
        return success;
    }

    public static String sanitizeFileName(String name) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch <= '\u0000' || ch >= '\u00ff') continue;
            if (Character.isLetterOrDigit(ch)) {
                result.append(ch);
                continue;
            }
            result.append("_");
        }
        return result.toString();
    }

    public static void setReadOnlyAttribute(String path, boolean readOnlyStatus) throws IOException {
        if (IO_FILE_SET_WRITABLE_METHOD != null) {
            try {
                IO_FILE_SET_WRITABLE_METHOD.invoke((Object)new File(path), !readOnlyStatus);
                return;
            }
            catch (IllegalAccessException e) {
                LOG.error(e);
            }
            catch (InvocationTargetException e) {
                LOG.error(e);
            }
        }
        Process process = SystemInfo.isWindows ? Runtime.getRuntime().exec(new String[]{"attrib", readOnlyStatus ? "+r" : "-r", path}) : Runtime.getRuntime().exec(new String[]{"chmod", readOnlyStatus ? "u-w" : "u+w", path});
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        Method method;
        LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileUtil");
        BUFFER = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[20480];
            }
        };
        try {
            method = File.class.getDeclaredMethod("setWritable", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_SET_WRITABLE_METHOD = method;
    }
}

