/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.containers.LockPoolSynchronizedMap;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDataHolderBase
implements UserDataHolderEx,
Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.UserDataHolderBase");
    private volatile Map<Key, Object> myUserMap = null;
    private static final Object WRITE_LOCK = new Object();
    private static final Key<Map<Key, Object>> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.myUserMap = null;
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error(e);
            return null;
        }
    }

    public String getUserDataString() {
        Map<Key, Object> userMap = this.myUserMap;
        if (userMap != null) {
            Map copyableMap = (Map)userMap.get(COPYABLE_USER_MAP_KEY);
            if (copyableMap == null) {
                return userMap.toString();
            }
            return userMap.toString() + copyableMap.toString();
        }
        return "";
    }

    @Override
    public <T> T getUserData(Key<T> key) {
        Map<Key, Object> map = this.myUserMap;
        return (T)(map == null ? null : map.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void putUserData(Key<T> key, T value) {
        Object object = WRITE_LOCK;
        synchronized (object) {
            if (this.myUserMap == null) {
                if (value == null) {
                    return;
                }
                this.myUserMap = UserDataHolderBase.createMap();
            }
            if (value != null) {
                this.myUserMap.put(key, value);
            } else {
                this.myUserMap.remove(key);
                if (this.myUserMap.isEmpty()) {
                    this.myUserMap = null;
                }
            }
        }
    }

    private static LockPoolSynchronizedMap<Key, Object> createMap() {
        return new LockPoolSynchronizedMap<Key, Object>(2, 0.9f);
    }

    public <T> T getCopyableUserData(Key<T> key) {
        return this.getCopyableUserDataImpl(key);
    }

    protected <T> T getCopyableUserDataImpl(Key<T> key) {
        Map<Key, Object> map = this.getUserData(COPYABLE_USER_MAP_KEY);
        return (T)(map == null ? null : map.get(key));
    }

    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.putCopyableUserDataImpl(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void putCopyableUserDataImpl(Key<T> key, T value) {
        Object object = WRITE_LOCK;
        synchronized (object) {
            Object map = this.getUserData(COPYABLE_USER_MAP_KEY);
            if (map == null) {
                if (value == null) {
                    return;
                }
                map = new LockPoolSynchronizedMap(1, 0.9f);
                this.putUserData(COPYABLE_USER_MAP_KEY, map);
            }
            if (value != null) {
                map.put(key, value);
            } else {
                map.remove(key);
                if (map.isEmpty()) {
                    this.putUserData(COPYABLE_USER_MAP_KEY, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        Object object;
        Object object2;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not be null");
        }
        Object object3 = WRITE_LOCK;
        synchronized (object3) {
            if (this.myUserMap == null) {
                this.myUserMap = UserDataHolderBase.createMap();
                this.myUserMap.put(key, value);
                T t = value;
                // MONITOREXIT @DISABLED, blocks:[3, 12] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                object2 = t;
                if (t == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not return null");
                return (T)object2;
            }
            Object prev = this.myUserMap.get(key);
            if (prev == null) {
                this.myUserMap.put(key, value);
                T t = value;
                // MONITOREXIT @DISABLED, blocks:[3, 11] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                object2 = t;
                if (t == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not return null");
                return (T)object2;
            }
            object = prev;
        }
        object2 = object;
        if (object != null) return (T)object2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean replace(@NotNull Key<T> key, @NotNull T oldValue, @Nullable T newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.replace must not be null");
        }
        if (oldValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.replace must not be null");
        }
        Object object = WRITE_LOCK;
        synchronized (object) {
            if (this.myUserMap == null) {
                if (newValue != null) {
                    this.myUserMap = UserDataHolderBase.createMap();
                    this.myUserMap.put(key, newValue);
                }
                return true;
            }
            Object prev = this.myUserMap.get(key);
            if (prev == null || prev.equals(oldValue)) {
                if (newValue != null) {
                    this.myUserMap.put(key, newValue);
                } else {
                    this.myUserMap.remove(key);
                    if (this.myUserMap.isEmpty()) {
                        this.myUserMap = null;
                    }
                }
                return true;
            }
            return false;
        }
    }

    protected void copyCopyableDataTo(UserDataHolderBase clone) {
        THashMap copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        if (copyableMap != null) {
            copyableMap = ((LockPoolSynchronizedMap)copyableMap).clone();
        }
        clone.putUserData(COPYABLE_USER_MAP_KEY, copyableMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearUserData() {
        Object object = WRITE_LOCK;
        synchronized (object) {
            this.myUserMap = null;
        }
    }
}

